/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import forestry.api.core.tooltips.TextCollection;
import forestry.api.core.tooltips.ToolTip;
import forestry.core.gui.elements.ActionConfig;
import forestry.core.gui.elements.ActionOrigin;
import forestry.core.gui.elements.Alignment;
import forestry.core.gui.elements.GuiElement;
import forestry.core.gui.elements.ITooltipSupplier;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;

public abstract class ElementBuilder<B extends ElementBuilder<B, E>, E extends GuiElement> {
    public final List<ITooltipSupplier> tooltipSuppliers = new LinkedList<ITooltipSupplier>();
    public Function<ActionConfig.Builder, ActionConfig.Builder> actionsCallback = builder -> builder;
    public ActionOrigin defaultOrigin = ActionOrigin.SELF;
    @Nullable
    public Point pos;
    public Dimension size = GuiElement.UNKNOWN_SIZE;
    public Alignment align = Alignment.TOP_LEFT;
    public boolean defaultVisibility = true;

    public B actionOrigin(ActionOrigin defaultOrigin) {
        this.defaultOrigin = defaultOrigin;
        return this.cast();
    }

    public B defineActions(ActionOrigin defaultOrigin, Function<ActionConfig.Builder, ActionConfig.Builder> callback) {
        this.actionsCallback = callback;
        this.defaultOrigin = defaultOrigin;
        return this.cast();
    }

    public B defineActions(Function<ActionConfig.Builder, ActionConfig.Builder> callback) {
        this.actionsCallback = callback;
        return this.cast();
    }

    public B pos(Point pos) {
        this.pos = pos;
        return this.cast();
    }

    public B pos(int x, int y) {
        return this.pos(new Point(x, y));
    }

    public B size(Dimension size) {
        this.size = size;
        return this.cast();
    }

    public B size(int width, int height) {
        return this.size(new Dimension(width, height));
    }

    public B size(int value) {
        return this.size(value, value);
    }

    public B align(Alignment align) {
        this.align = align;
        return this.cast();
    }

    public B visible(boolean visible) {
        this.defaultVisibility = visible;
        return this.cast();
    }

    public B hide() {
        return this.visible(false);
    }

    public B show() {
        return this.visible(true);
    }

    public B addTooltip(ITextComponent line) {
        this.addTooltip((ToolTip toolTip, GuiElement element, int mouseX, int mouseY) -> toolTip.add(line));
        return this.cast();
    }

    public B addTooltip(Collection<ITextComponent> lines) {
        this.addTooltip((ToolTip toolTip, GuiElement element, int mouseX, int mouseY) -> {
            TextCollection cfr_ignored_0 = (TextCollection)toolTip.addAll(lines);
        });
        return this.cast();
    }

    public B addTooltip(Supplier<ITextComponent> line) {
        this.addTooltip((ToolTip toolTip, GuiElement element, int mouseX, int mouseY) -> toolTip.add((ITextComponent)line.get()));
        return this.cast();
    }

    public B addTooltip(ITooltipSupplier supplier) {
        this.tooltipSuppliers.add(supplier);
        return this.cast();
    }

    protected B cast() {
        return (B)this;
    }

    public abstract E create();
}

