/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import forestry.core.gui.GuiForestry;
import forestry.core.render.ColourProperties;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TextLayoutHelper {
    private static final int LINE_HEIGHT = 12;
    private final GuiForestry guiForestry;
    private final int defaultFontColor;
    public int column0;
    public int column1;
    public int column2;
    public int line;

    public TextLayoutHelper(GuiForestry guiForestry, ColourProperties fontColour) {
        this.guiForestry = guiForestry;
        this.defaultFontColor = fontColour.get("gui.screen");
    }

    public void startPage() {
        this.line = 12;
        RenderSystem.pushMatrix();
    }

    public void startPage(int column0, int column1) {
        this.startPage(column0, column1, 0);
    }

    public void startPage(int column0, int column1, int column2) {
        this.column0 = column0;
        this.column1 = column1;
        this.column2 = column2;
        this.startPage();
    }

    public int getLineY() {
        return this.line;
    }

    public void newLine() {
        this.line += 12;
    }

    public void newLineCompressed() {
        this.line += 10;
    }

    public void newLine(int lineHeight) {
        this.line += lineHeight;
    }

    public void endPage() {
        RenderSystem.popMatrix();
    }

    public void drawRow(MatrixStack transform, String text0, String text1, String text2, int colour0, int colour1, int colour2) {
        this.drawLine(transform, text0, this.column0, colour0);
        this.drawLine(transform, text1, this.column1, colour1);
        this.drawLine(transform, text2, this.column2, colour2);
    }

    public void drawLine(MatrixStack transform, String text, int x) {
        this.drawLine(transform, text, x, this.defaultFontColor);
    }

    public void drawLine(MatrixStack transform, ITextComponent component, int x) {
        this.drawLine(transform, component, x, this.defaultFontColor);
    }

    public void drawTranslatedLine(MatrixStack transform, String key, int x) {
        this.drawLine(transform, (ITextComponent)new TranslationTextComponent(key), x, this.defaultFontColor);
    }

    public void drawSplitLine(String text, int x, int maxWidth) {
        this.drawSplitLine(text, x, maxWidth, this.defaultFontColor);
    }

    public void drawCenteredLine(MatrixStack transform, String text, int x, int color) {
        this.drawCenteredLine(transform, text, x, this.guiForestry.getSizeX(), color);
    }

    public void drawCenteredLine(MatrixStack transform, String text, int x, int width, int color) {
        this.drawCenteredLine(transform, text, x, 0, width, color);
    }

    public void drawCenteredLine(MatrixStack transform, String text, int x, int y, int width, int color) {
        this.guiForestry.getFontRenderer().func_238421_b_(transform, text, (float)(this.guiForestry.getGuiLeft() + x + this.getCenteredOffset(text, width)), (float)(this.guiForestry.getGuiTop() + y + this.line), color);
    }

    public void drawLine(MatrixStack transform, String text, int x, int color) {
        this.drawLine(transform, text, x, 0, color);
    }

    public void drawLine(MatrixStack transform, ITextComponent component, int x, int color) {
        this.drawLine(transform, component, x, 0, color);
    }

    public void drawLine(MatrixStack transform, String text, int x, int y, int color) {
        this.guiForestry.getFontRenderer().func_238421_b_(transform, text, (float)(this.guiForestry.getGuiLeft() + x), (float)(this.guiForestry.getGuiTop() + y + this.line), color);
    }

    public void drawLine(MatrixStack transform, ITextComponent component, int x, int y, int color) {
        this.guiForestry.getFontRenderer().func_243248_b(transform, component, (float)(this.guiForestry.getGuiLeft() + x), (float)(this.guiForestry.getGuiTop() + y + this.line), color);
    }

    public void drawSplitLine(String text, int x, int maxWidth, int color) {
        this.drawSplitLine((ITextComponent)new StringTextComponent(text), x, maxWidth, color);
    }

    public void drawSplitLine(ITextComponent component, int x, int maxWidth, int color) {
        this.guiForestry.getFontRenderer().func_238418_a_((ITextProperties)component, this.guiForestry.getGuiLeft() + x, this.guiForestry.getGuiTop() + this.line, maxWidth, color);
    }

    public int getCenteredOffset(String string) {
        return this.getCenteredOffset(string, this.guiForestry.getSizeX());
    }

    public int getCenteredOffset(String string, int xWidth) {
        return (xWidth - this.guiForestry.getFontRenderer().func_78256_a(string)) / 2;
    }
}

