/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import forestry.api.genetics.gatgets.IGeneticAnalyzer;
import forestry.api.genetics.gatgets.IGeneticAnalyzerProvider;
import forestry.core.gui.Drawable;
import forestry.core.gui.GuiForestryTitled;
import forestry.core.gui.IContainerAnalyzerProvider;
import forestry.core.gui.buttons.GuiToggleButton;
import forestry.core.gui.elements.GeneticAnalyzer;
import forestry.core.gui.elements.GuiElement;
import forestry.core.gui.elements.GuiElementFactory;
import forestry.core.gui.slots.SlotAnalyzer;
import forestry.core.inventory.ItemInventoryAlyzer;
import forestry.core.inventory.watchers.ISlotChangeWatcher;
import forestry.core.tiles.ITitled;
import javax.annotation.Nullable;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class GuiAnalyzerProvider<C extends Container>
extends GuiForestryTitled<C>
implements IGeneticAnalyzerProvider,
ISlotChangeWatcher {
    protected static final Drawable SELECTED_COMB_SLOT = new Drawable(GeneticAnalyzer.TEXTURE, 163, 0, 22, 22);
    protected static final Drawable TOGGLE_BUTTON = new Drawable(GeneticAnalyzer.TEXTURE, 35, 166, 18, 20);
    private static boolean analyzerVisible = false;
    public final IGeneticAnalyzer analyzer;
    @Nullable
    private SlotAnalyzer slotAnalyzer;
    private final int buttonX;
    private final int buttonY;
    private final int screenDistance;
    private final int slots;
    private final int firstSlot;
    protected boolean deactivated;
    private boolean dirtyAnalyzer = false;
    private boolean dirty = true;
    private boolean slotDirty;

    public GuiAnalyzerProvider(String texture, C container, PlayerInventory inv, ITitled titled, int buttonX, int buttonY, int slots, int firstSlot) {
        this(texture, container, inv, titled, buttonX, buttonY, 0, false, slots, firstSlot);
    }

    public GuiAnalyzerProvider(String texture, C container, PlayerInventory inv, ITitled titled, int buttonX, int buttonY, int screenDistance, boolean hasBorder, int slots, int firstSlot) {
        super(texture, container, inv, (ITextComponent)new TranslationTextComponent(titled.getUnlocalizedTitle()));
        IContainerAnalyzerProvider containerAnalyzer;
        Slot slot;
        this.buttonX = buttonX;
        this.buttonY = buttonY;
        this.screenDistance = screenDistance;
        this.slots = slots;
        this.firstSlot = firstSlot;
        this.analyzer = GuiElementFactory.INSTANCE.createAnalyzer(this.window, -189 - screenDistance, 0, hasBorder, this);
        this.updateVisibility();
        SlotAnalyzer analyzerSlot = null;
        if (container instanceof IContainerAnalyzerProvider && (slot = (containerAnalyzer = (IContainerAnalyzerProvider)container).getAnalyzerSlot()) instanceof SlotAnalyzer) {
            ((SlotAnalyzer)slot).setVisibleCallback(this.analyzer::isVisible);
            analyzerSlot = (SlotAnalyzer)slot;
        }
        this.slotAnalyzer = analyzerSlot;
        this.slotDirty = true;
    }

    protected boolean hasErrors() {
        return false;
    }

    private void updateVisibility() {
        this.analyzer.setVisible(!this.deactivated && analyzerVisible);
    }

    protected abstract void drawSelectedSlot(MatrixStack var1, int var2);

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        if (this.analyzer.isVisible()) {
            this.field_147003_i = (this.field_230708_k_ - this.field_146999_f + ((GuiElement)((Object)this.analyzer)).getWidth() + this.screenDistance) / 2;
        }
        this.window.init(this.field_147003_i, this.field_147009_r + (this.field_147000_g - 166) / 2);
        ((GuiToggleButton)this.func_230480_a_((Widget)new GuiToggleButton((int)(this.field_147003_i + this.buttonX), (int)(this.field_147009_r + this.buttonY), (int)18, (int)20, (Drawable)GuiAnalyzerProvider.TOGGLE_BUTTON, (Button.IPressable)(GuiAnalyzerProvider)this.new Handler()))).field_230694_p_ = ((IContainerAnalyzerProvider)this.container).getAnalyzerSlot() != null;
        this.dirty = true;
        this.slotDirty = true;
    }

    @Override
    public void func_230430_a_(MatrixStack transform, int mouseX, int mouseY, float partialTicks) {
        boolean ledger = this.hasErrors();
        if (!this.deactivated && ledger || !ledger && this.deactivated) {
            this.deactivated = ledger;
            this.updateVisibility();
            this.dirtyAnalyzer = true;
        }
        if (this.dirtyAnalyzer) {
            this.field_230710_m_.clear();
            this.func_231160_c_();
            this.dirtyAnalyzer = false;
        }
        if (this.dirty) {
            this.analyzer.update();
            this.dirty = false;
        }
        super.func_230430_a_(transform, mouseX, mouseY, partialTicks);
        if (this.slotDirty) {
            if (this.slotAnalyzer != null) {
                GuiElement element = this.analyzer.getItemElement();
                int index = this.slotAnalyzer.field_75222_d;
                this.slotAnalyzer = new SlotAnalyzer((ItemInventoryAlyzer)this.slotAnalyzer.field_75224_c, this.slotAnalyzer.getSlotIndex(), element.getAbsoluteX() - this.field_147003_i + 6, element.getAbsoluteY() - this.field_147009_r + 9);
                this.slotAnalyzer.field_75222_d = index;
                this.slotAnalyzer.setVisibleCallback(this.analyzer::isVisible);
                this.container.field_75151_b.set(index, this.slotAnalyzer);
            }
            this.slotDirty = false;
        }
    }

    @Override
    protected void func_230450_a_(MatrixStack transform, float partialTicks, int mouseX, int mouseY) {
        int selectedSlot;
        super.func_230450_a_(transform, partialTicks, mouseX, mouseY);
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.analyzer.isVisible() && (selectedSlot = this.analyzer.getSelected()) >= 0) {
            this.drawSelectedSlot(transform, selectedSlot);
        }
    }

    @Override
    public void onSlotChanged(IInventory inventory, int slot) {
        if (slot == this.analyzer.getSelected()) {
            this.dirty = true;
        }
    }

    @Override
    public int getSelectedSlot(int index) {
        return 1 + index;
    }

    @Override
    public int getSlotCount() {
        return this.slots;
    }

    @Override
    public int getFirstSlot() {
        return this.firstSlot;
    }

    private static void setAnalyzerVisible(boolean analyzerVisible) {
        GuiAnalyzerProvider.analyzerVisible = analyzerVisible;
    }

    private static boolean isAnalyzerVisible() {
        return analyzerVisible;
    }

    class Handler
    implements Button.IPressable {
        Handler() {
        }

        public void onPress(Button button) {
            if (button instanceof GuiToggleButton) {
                GuiAnalyzerProvider.setAnalyzerVisible(!GuiAnalyzerProvider.isAnalyzerVisible());
                GuiAnalyzerProvider.this.updateVisibility();
                GuiAnalyzerProvider.this.dirtyAnalyzer = true;
            }
        }
    }
}

