/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import com.google.common.collect.ImmutableSet;
import forestry.api.core.IErrorLogicSource;
import forestry.api.core.IErrorState;
import forestry.core.gui.ContainerForestry;
import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.packets.PacketErrorUpdate;
import forestry.core.network.packets.PacketGuiEnergy;
import forestry.core.network.packets.PacketGuiUpdate;
import forestry.core.tiles.IPowerHandler;
import forestry.core.tiles.TilePowered;
import forestry.core.tiles.TileUtil;
import forestry.energy.EnergyManager;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class ContainerTile<T extends TileEntity>
extends ContainerForestry {
    protected final T tile;
    @Nullable
    private ImmutableSet<IErrorState> previousErrorStates;
    private int previousEnergyManagerData = 0;
    private int previousWorkCounter = 0;
    private int previousTicksPerWorkCycle = 0;

    protected ContainerTile(int windowId, ContainerType<?> type, PlayerInventory playerInventory, T tile, int xInv, int yInv) {
        super(windowId, type);
        this.addPlayerInventory(playerInventory, xInv, yInv);
        this.tile = tile;
    }

    protected ContainerTile(int windowId, ContainerType<?> type, T tile) {
        super(windowId, type);
        this.tile = tile;
    }

    @Override
    protected final boolean canAccess(PlayerEntity player) {
        return true;
    }

    public final boolean func_75145_c(PlayerEntity PlayerEntity2) {
        return TileUtil.isUsableByPlayer(PlayerEntity2, this.tile);
    }

    public void func_75142_b() {
        EnergyManager energyManager;
        int energyManagerData;
        ForestryPacket packet;
        super.func_75142_b();
        if (this.tile instanceof IErrorLogicSource) {
            IErrorLogicSource errorLogicSource = (IErrorLogicSource)this.tile;
            ImmutableSet<IErrorState> errorStates = errorLogicSource.getErrorLogic().getErrorStates();
            if (!errorStates.equals(this.previousErrorStates)) {
                packet = new PacketErrorUpdate((TileEntity)this.tile, errorLogicSource);
                this.sendPacketToListeners((IForestryPacketClient)((Object)packet));
            }
            this.previousErrorStates = errorStates;
        }
        if (this.tile instanceof IPowerHandler && (energyManagerData = (energyManager = ((IPowerHandler)this.tile).getEnergyManager()).getEnergyStored()) != this.previousEnergyManagerData) {
            packet = new PacketGuiEnergy(this.field_75152_c, energyManagerData);
            this.sendPacketToListeners((IForestryPacketClient)((Object)packet));
            this.previousEnergyManagerData = energyManagerData;
        }
        if (this.tile instanceof TilePowered) {
            int ticksPerWorkCycle;
            boolean guiNeedsUpdate = false;
            TilePowered tilePowered = (TilePowered)this.tile;
            int workCounter = tilePowered.getWorkCounter();
            if (workCounter != this.previousWorkCounter) {
                guiNeedsUpdate = true;
                this.previousWorkCounter = workCounter;
            }
            if ((ticksPerWorkCycle = tilePowered.getTicksPerWorkCycle()) != this.previousTicksPerWorkCycle) {
                guiNeedsUpdate = true;
                this.previousTicksPerWorkCycle = ticksPerWorkCycle;
            }
            if (guiNeedsUpdate) {
                PacketGuiUpdate packet2 = new PacketGuiUpdate(tilePowered);
                this.sendPacketToListeners(packet2);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onGuiEnergy(int energyStored) {
        if (this.tile instanceof IPowerHandler) {
            EnergyManager energyManager = ((IPowerHandler)this.tile).getEnergyManager();
            energyManager.setEnergyStored(energyStored);
        }
    }

    public T getTile() {
        return this.tile;
    }
}

