/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuitBoard;
import forestry.core.circuits.ISocketable;
import forestry.core.circuits.ISolderingIron;
import forestry.core.gui.IContainerSocketed;
import forestry.core.network.packets.PacketChipsetClick;
import forestry.core.network.packets.PacketSocketUpdate;
import forestry.core.network.packets.PacketSolderingIronClick;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.NetworkUtil;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ContainerSocketedHelper<T extends TileEntity>
implements IContainerSocketed {
    private final T tile;

    public ContainerSocketedHelper(T tile) {
        this.tile = tile;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleChipsetClick(int slot) {
        NetworkUtil.sendToServer(new PacketChipsetClick(slot));
    }

    @Override
    public void handleChipsetClickServer(int slot, ServerPlayerEntity player, ItemStack itemstack) {
        if (!((ISocketable)this.tile).getSocket(slot).func_190926_b()) {
            return;
        }
        if (!ChipsetManager.circuitRegistry.isChipset(itemstack)) {
            return;
        }
        ICircuitBoard circuitBoard = ChipsetManager.circuitRegistry.getCircuitBoard(itemstack);
        if (circuitBoard == null) {
            return;
        }
        if (!((ISocketable)this.tile).getSocketType().equals(circuitBoard.getSocketType())) {
            return;
        }
        ItemStack toSocket = itemstack.func_77946_l();
        toSocket.func_190920_e(1);
        ((ISocketable)this.tile).setSocket(slot, toSocket);
        ItemStack stack = player.field_71071_by.func_70445_o();
        stack.func_190918_g(1);
        player.func_71113_k();
        PacketSocketUpdate packet = new PacketSocketUpdate(this.tile);
        NetworkUtil.sendToPlayer(packet, (PlayerEntity)player);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleSolderingIronClick(int slot) {
        NetworkUtil.sendToServer(new PacketSolderingIronClick(slot));
    }

    @Override
    public void handleSolderingIronClickServer(int slot, ServerPlayerEntity player, ItemStack itemstack) {
        ItemStack socket = ((ISocketable)this.tile).getSocket(slot);
        if (socket.func_190926_b() || !(itemstack.func_77973_b() instanceof ISolderingIron)) {
            return;
        }
        if (!InventoryUtil.stowInInventory(socket, (IInventory)player.field_71071_by, false)) {
            return;
        }
        ((ISocketable)this.tile).setSocket(slot, ItemStack.field_190927_a);
        InventoryUtil.stowInInventory(socket, (IInventory)player.field_71071_by, true);
        itemstack.func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(p.func_184600_cs()));
        player.func_71113_k();
        PacketSocketUpdate packet = new PacketSocketUpdate(this.tile);
        NetworkUtil.sendToPlayer(packet, (PlayerEntity)player);
    }
}

