/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.core.circuits.ISocketable;
import forestry.core.gui.ContainerLiquidTanksHelper;
import forestry.core.gui.ContainerSocketedHelper;
import forestry.core.gui.ContainerTile;
import forestry.core.gui.IContainerLiquidTanks;
import forestry.core.gui.IContainerSocketed;
import forestry.core.tiles.ILiquidTankTile;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.IFluidTank;

public abstract class ContainerLiquidTanksSocketed<T extends TileEntity & ISocketable>
extends ContainerTile<T>
implements IContainerSocketed,
IContainerLiquidTanks {
    private final ContainerSocketedHelper<T> socketedHelper;
    private final ContainerLiquidTanksHelper<T> tanksHelper;

    protected ContainerLiquidTanksSocketed(int windowId, ContainerType<?> type, PlayerInventory playerInventory, T tile, int xInv, int yInv) {
        super(windowId, type, playerInventory, tile, xInv, yInv);
        this.socketedHelper = new ContainerSocketedHelper<TileEntity>(this.tile);
        this.tanksHelper = new ContainerLiquidTanksHelper<TileEntity>(this.tile);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handlePipetteClickClient(int slot, PlayerEntity player) {
        this.tanksHelper.handlePipetteClickClient(slot, player);
    }

    @Override
    public void handlePipetteClick(int slot, ServerPlayerEntity player) {
        this.tanksHelper.handlePipetteClick(slot, player);
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        ((ILiquidTankTile)this.tile).getTankManager().sendTankUpdate(this, this.field_75149_d);
    }

    public void func_75132_a(IContainerListener crafting) {
        super.func_75132_a(crafting);
        ((ILiquidTankTile)this.tile).getTankManager().containerAdded(this, crafting);
    }

    public void func_75134_a(PlayerEntity PlayerEntity2) {
        super.func_75134_a(PlayerEntity2);
        ((ILiquidTankTile)this.tile).getTankManager().containerRemoved(this);
    }

    @Override
    public IFluidTank getTank(int slot) {
        return ((ILiquidTankTile)this.tile).getTankManager().getTank(slot);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleChipsetClick(int slot) {
        this.socketedHelper.handleChipsetClick(slot);
    }

    @Override
    public void handleChipsetClickServer(int slot, ServerPlayerEntity player, ItemStack itemstack) {
        this.socketedHelper.handleChipsetClickServer(slot, player, itemstack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleSolderingIronClick(int slot) {
        this.socketedHelper.handleSolderingIronClick(slot);
    }

    @Override
    public void handleSolderingIronClickServer(int slot, ServerPlayerEntity player, ItemStack itemstack) {
        this.socketedHelper.handleSolderingIronClickServer(slot, player, itemstack);
    }
}

