/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class PipetteContents {
    private final FluidStack contents;

    @Nullable
    public static PipetteContents create(ItemStack itemStack) {
        FluidStack contents = FluidUtil.getFluidContained((ItemStack)itemStack).orElse(FluidStack.EMPTY);
        if (contents.isEmpty()) {
            return null;
        }
        return new PipetteContents(contents);
    }

    public PipetteContents(FluidStack contents) {
        this.contents = contents;
    }

    public FluidStack getContents() {
        return this.contents;
    }

    public boolean isFull() {
        return this.contents.getAmount() >= 1000;
    }

    public void addTooltip(List<ITextComponent> list) {
        TranslationTextComponent descr = new TranslationTextComponent(this.contents.getFluid().getAttributes().getTranslationKey(this.contents));
        descr.func_240702_b_(" (" + this.contents.getAmount() + " mb)");
        list.add((ITextComponent)descr);
    }
}

