/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.errors;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import forestry.api.core.IErrorLogic;
import forestry.api.core.IErrorState;
import forestry.api.core.IErrorStateRegistry;
import forestry.api.core.ISpriteRegistry;
import forestry.core.errors.ErrorLogic;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ErrorStateRegistry
implements IErrorStateRegistry {
    private static final BiMap<Short, IErrorState> states = HashBiMap.create();
    private static final Map<String, IErrorState> stateNames = new HashMap<String, IErrorState>();
    private static final Set<IErrorState> stateView = Collections.unmodifiableSet(states.inverse().keySet());

    @Override
    public void registerErrorState(IErrorState state) {
        if (states.containsKey((Object)state.getID())) {
            throw new RuntimeException("Forestry Error State does not possess a unique id.");
        }
        states.put((Object)state.getID(), (Object)state);
        ErrorStateRegistry.addStateName(state, state.getUniqueName());
    }

    @Override
    public void addAlias(IErrorState state, String name) {
        if (!states.containsValue((Object)state)) {
            throw new RuntimeException("Forestry Error State did not exist while trying to register alias.");
        }
        ErrorStateRegistry.addStateName(state, name);
    }

    private static void addStateName(IErrorState state, String name) {
        if (!name.contains(":")) {
            throw new RuntimeException("Forestry Error State name must be in the format <modid>:<name>.");
        }
        if (stateNames.containsKey(name)) {
            throw new RuntimeException("Forestry Error State does not possess a unique name.");
        }
        stateNames.put(name, state);
    }

    @Override
    public IErrorState getErrorState(short id) {
        return (IErrorState)states.get((Object)id);
    }

    @Override
    public IErrorState getErrorState(String name) {
        return stateNames.get(name);
    }

    @Override
    public Set<IErrorState> getErrorStates() {
        return stateView;
    }

    @Override
    public IErrorLogic createErrorLogic() {
        return new ErrorLogic();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void initSprites(ISpriteRegistry event) {
        for (IErrorState code : states.values()) {
            code.registerSprites(event);
        }
    }
}

