/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import forestry.api.recipes.ICarpenterRecipe;
import forestry.core.data.builder.Holder;
import forestry.factory.recipes.RecipeSerializers;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.ImpossibleTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class CarpenterRecipeBuilder {
    private int packagingTime;
    @Nullable
    private FluidStack liquid;
    private Ingredient box;
    private IFinishedRecipe recipe;
    @Nullable
    private ItemStack result;

    public CarpenterRecipeBuilder setPackagingTime(int packagingTime) {
        this.packagingTime = packagingTime;
        return this;
    }

    public CarpenterRecipeBuilder setLiquid(@Nullable FluidStack liquid) {
        this.liquid = liquid;
        return this;
    }

    public CarpenterRecipeBuilder setBox(Ingredient box) {
        this.box = box;
        return this;
    }

    public CarpenterRecipeBuilder recipe(ShapedRecipeBuilder recipe) {
        Holder holder = new Holder();
        recipe.func_200465_a("impossible", (ICriterionInstance)new ImpossibleTrigger.Instance()).func_200464_a(holder::set);
        this.recipe = (IFinishedRecipe)holder.get();
        return this;
    }

    public CarpenterRecipeBuilder recipe(ShapelessRecipeBuilder recipe) {
        Holder holder = new Holder();
        recipe.func_200483_a("impossible", (ICriterionInstance)new ImpossibleTrigger.Instance()).func_200482_a(holder::set);
        this.recipe = (IFinishedRecipe)holder.get();
        return this;
    }

    public CarpenterRecipeBuilder override(ItemStack result) {
        this.result = result;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this.packagingTime, this.liquid, this.box, this.recipe, this.result));
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final int packagingTime;
        @Nullable
        private final FluidStack liquid;
        private final Ingredient box;
        private final IFinishedRecipe recipe;
        @Nullable
        private final ItemStack result;

        public Result(ResourceLocation id, int packagingTime, @Nullable FluidStack liquid, Ingredient box, IFinishedRecipe recipe, @Nullable ItemStack result) {
            this.id = id;
            this.packagingTime = packagingTime;
            this.liquid = liquid;
            this.box = box;
            this.recipe = recipe;
            this.result = result;
        }

        public void func_218610_a(JsonObject json) {
            json.addProperty("time", (Number)this.packagingTime);
            if (this.liquid != null) {
                json.add("liquid", (JsonElement)RecipeSerializers.serializeFluid(this.liquid));
            }
            json.add("box", this.box.func_200304_c());
            json.add("recipe", (JsonElement)this.recipe.func_200441_a());
            if (this.result != null) {
                json.add("result", (JsonElement)RecipeSerializers.item(this.result));
            }
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return ICarpenterRecipe.Companion.SERIALIZER;
        }

        public JsonObject func_200440_c() {
            return null;
        }

        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

