/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data;

import forestry.api.arboriculture.EnumForestryWoodType;
import forestry.api.arboriculture.IWoodType;
import forestry.core.data.ModelProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.util.ResourceLocation;

public class WoodBlockModelProvider
extends ModelProvider {
    public WoodBlockModelProvider(DataGenerator generator) {
        super(generator, "block");
    }

    @Override
    protected void registerModels() {
        for (EnumForestryWoodType type : EnumForestryWoodType.VALUES) {
            this.addPlank(type);
            this.addLog(type);
            this.addStair(type);
            this.addSlab(type);
            this.addFence(type);
            this.addFenceGate(type);
            this.addDoor(type);
        }
        this.registerModel("leaves", new ModelProvider.ModelBuilder().parent("block/cube_all").texture("all", new ResourceLocation("forestry", "block/leaves/deciduous.plain")));
    }

    private void addPlank(IWoodType type) {
        this.registerModel("arboriculture/planks/" + type.func_176610_l(), new ModelProvider.ModelBuilder().parent("block/cube_all").texture("all", new ResourceLocation("forestry", "block/wood/planks." + type.func_176610_l())));
    }

    private void addLog(IWoodType type) {
        this.registerModel("arboriculture/logs/" + type.func_176610_l(), new ModelProvider.ModelBuilder().parent("block/cube_column").texture("side", new ResourceLocation("forestry", "block/wood/bark." + type.func_176610_l())).texture("end", new ResourceLocation("forestry", "block/wood/heart." + type.func_176610_l())));
    }

    private void addStair(IWoodType type) {
        ResourceLocation texture = new ResourceLocation("forestry", "block/wood/planks." + type.func_176610_l());
        this.registerModel("arboriculture/stairs/" + type.func_176610_l(), new ModelProvider.ModelBuilder().parent("block/stairs").texture("side", texture).texture("top", texture).texture("bottom", texture).particle(texture));
        this.registerModel("arboriculture/stairs/" + type.func_176610_l() + "_inner", new ModelProvider.ModelBuilder().parent("block/inner_stairs").texture("side", texture).texture("top", texture).texture("bottom", texture).particle(texture));
        this.registerModel("arboriculture/stairs/" + type.func_176610_l() + "_outer", new ModelProvider.ModelBuilder().parent("block/outer_stairs").texture("side", texture).texture("top", texture).texture("bottom", texture).particle(texture));
    }

    private void addSlab(IWoodType type) {
        ResourceLocation texture = new ResourceLocation("forestry", "block/wood/planks." + type.func_176610_l());
        this.registerModel("arboriculture/slabs/" + type.func_176610_l() + "_top", new ModelProvider.ModelBuilder().parent("block/slab_top").texture("side", texture).texture("top", texture).texture("bottom", texture).particle(texture));
        this.registerModel("arboriculture/slabs/" + type.func_176610_l(), new ModelProvider.ModelBuilder().parent("block/slab").texture("side", texture).texture("top", texture).texture("bottom", texture).particle(texture));
    }

    private void addFence(IWoodType type) {
        ResourceLocation texture = new ResourceLocation("forestry", "block/wood/planks." + type.func_176610_l());
        this.registerModel("arboriculture/fences/" + type.func_176610_l() + "_side", new ModelProvider.ModelBuilder().parent("block/fence_side").texture("texture", texture));
        this.registerModel("arboriculture/fences/" + type.func_176610_l(), new ModelProvider.ModelBuilder().parent("block/fence_post").texture("texture", texture));
        this.registerModel("arboriculture/fences/" + type.func_176610_l() + "_inventory", new ModelProvider.ModelBuilder().parent("block/fence_inventory").texture("texture", texture));
    }

    private void addFenceGate(IWoodType type) {
        ResourceLocation texture = new ResourceLocation("forestry", "block/wood/planks." + type.func_176610_l());
        this.registerModel("arboriculture/fence_gates/" + type.func_176610_l() + "_wall_open", new ModelProvider.ModelBuilder().parent("block/template_fence_gate_wall_open").texture("texture", texture));
        this.registerModel("arboriculture/fence_gates/" + type.func_176610_l() + "_wall", new ModelProvider.ModelBuilder().parent("block/template_fence_gate_wall").texture("texture", texture));
        this.registerModel("arboriculture/fence_gates/" + type.func_176610_l() + "_open", new ModelProvider.ModelBuilder().parent("block/template_fence_gate_open").texture("texture", texture));
        this.registerModel("arboriculture/fence_gates/" + type.func_176610_l(), new ModelProvider.ModelBuilder().parent("block/template_fence_gate").texture("texture", texture));
    }

    private void addDoor(IWoodType type) {
        ResourceLocation top = new ResourceLocation("forestry", "block/doors/" + type.func_176610_l() + "_upper");
        ResourceLocation bottom = new ResourceLocation("forestry", "block/doors/" + type.func_176610_l() + "_lower");
        this.registerModel("arboriculture/doors/" + type.func_176610_l() + "_bottom", new ModelProvider.ModelBuilder().parent("block/door_bottom").texture("top", top).texture("bottom", bottom));
        this.registerModel("arboriculture/doors/" + type.func_176610_l() + "_bottom_hinge", new ModelProvider.ModelBuilder().parent("block/door_bottom_rh").texture("top", top).texture("bottom", bottom));
        this.registerModel("arboriculture/doors/" + type.func_176610_l() + "_top", new ModelProvider.ModelBuilder().parent("block/door_top").texture("top", top).texture("bottom", bottom));
        this.registerModel("arboriculture/doors/" + type.func_176610_l() + "_top_hinge", new ModelProvider.ModelBuilder().parent("block/door_top_rh").texture("top", top).texture("bottom", bottom));
    }
}

