/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.blocks;

import com.mojang.authlib.GameProfile;
import forestry.core.owner.IOwnedTile;
import forestry.core.owner.IOwnerHandler;
import forestry.core.tiles.TileForestry;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.Log;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public abstract class BlockForestry
extends Block {
    protected BlockForestry(AbstractBlock.Properties properties) {
        this(properties, false);
    }

    protected BlockForestry(AbstractBlock.Properties properties, boolean defaultStrength) {
        super(defaultStrength ? properties.func_200943_b(1.5f) : properties);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        if (placer instanceof PlayerEntity) {
            TileUtil.actOnTile((IWorldReader)world, pos, IOwnedTile.class, tile -> {
                IOwnerHandler ownerHandler = tile.getOwnerHandler();
                PlayerEntity player = (PlayerEntity)placer;
                GameProfile gameProfile = player.func_146103_bH();
                ownerHandler.setOwner(gameProfile);
            });
        }
    }

    public void onNeighborChange(BlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, world, pos, neighbor);
        if (world instanceof World) {
            try {
                TileUtil.actOnTile(world, pos, TileForestry.class, tile -> tile.onNeighborTileChange((World)world, pos, neighbor));
            }
            catch (StackOverflowError error) {
                Log.error("Stack Overflow Error in BlockForestry.onNeighborChange()", error);
                throw error;
            }
        }
    }
}

