/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.blocks;

import forestry.core.features.CoreBlocks;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.ToolType;

public class BlockBogEarth
extends Block {
    private static final int maturityDelimiter = 3;
    public static final IntegerProperty MATURITY = IntegerProperty.func_177719_a((String)"maturity", (int)0, (int)3);

    public BlockBogEarth() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151578_c).func_200944_c().func_200943_b(0.5f).func_200947_a(SoundType.field_185849_b).harvestTool(ToolType.SHOVEL).harvestLevel(0));
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)MATURITY, (Comparable)Integer.valueOf(0)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{MATURITY});
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        if (world.field_72995_K || world.field_73012_v.nextInt(13) != 0) {
            return;
        }
        int maturity = (Integer)state.func_177229_b((Property)MATURITY);
        if (BlockBogEarth.isMoistened((World)world, pos)) {
            if (maturity == 2) {
                world.func_180501_a(pos, CoreBlocks.PEAT.defaultState(), 2);
            } else {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)MATURITY, (Comparable)Integer.valueOf(maturity + 1)), 2);
            }
        }
    }

    private static boolean isMoistened(World world, BlockPos pos) {
        for (BlockPos waterPos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-2, -2, -2), (BlockPos)pos.func_177982_a(2, 2, 2))) {
            BlockState blockState = world.func_180495_p(waterPos);
            Block block = blockState.func_177230_c();
            if (block != Blocks.field_150355_j) continue;
            return true;
        }
        return false;
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction direction, IPlantable plantable) {
        return false;
    }
}

