/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.blocks;

import com.mojang.authlib.GameProfile;
import forestry.api.core.ISpriteRegister;
import forestry.api.core.ISpriteRegistry;
import forestry.core.blocks.BlockForestry;
import forestry.core.blocks.IBlockType;
import forestry.core.blocks.IBlockTypeCustom;
import forestry.core.blocks.IBlockTypeTesr;
import forestry.core.blocks.IMachineProperties;
import forestry.core.blocks.IMachinePropertiesTesr;
import forestry.core.circuits.ISocketable;
import forestry.core.owner.IOwnedTile;
import forestry.core.owner.IOwnerHandler;
import forestry.core.render.MachineParticleCallback;
import forestry.core.render.ParticleHelper;
import forestry.core.tiles.TileBase;
import forestry.core.tiles.TileForestry;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.InventoryUtil;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidUtil;

public class BlockBase<P extends Enum<P>>
extends BlockForestry
implements ISpriteRegister {
    public static final EnumProperty<Direction> FACING = EnumProperty.func_177706_a((String)"facing", Direction.class, (Enum[])new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.DOWN, Direction.UP});
    private final boolean hasTESR;
    public final P blockType;
    private final ParticleHelper.Callback particleCallback;

    private static AbstractBlock.Properties createProperties(IBlockType type, AbstractBlock.Properties properties) {
        if (type instanceof IBlockTypeTesr || type instanceof IBlockTypeCustom) {
            properties = properties.func_226896_b_();
        }
        return properties.func_200943_b(2.0f);
    }

    public BlockBase(P blockType, AbstractBlock.Properties properties) {
        super(BlockBase.createProperties((IBlockType)blockType, properties));
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(FACING, (Comparable)Direction.NORTH));
        this.blockType = blockType;
        ((IBlockType)blockType).getMachineProperties().setBlock(this);
        this.hasTESR = blockType instanceof IBlockTypeTesr;
        this.particleCallback = new MachineParticleCallback<P>(this, blockType);
    }

    public BlockBase(P blockType, Material material) {
        this(blockType, AbstractBlock.Properties.func_200945_a((Material)material));
    }

    public BlockBase(P blockType) {
        this(blockType, Material.field_151573_f);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FACING});
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState p_220080_1_, IBlockReader p_220080_2_, BlockPos p_220080_3_) {
        return 0.2f;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        if (this.hasTESR) {
            return BlockRenderType.ENTITYBLOCK_ANIMATED;
        }
        return BlockRenderType.MODEL;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return this.getDefinition().createTileEntity();
    }

    private IMachineProperties<?> getDefinition() {
        return ((IBlockType)this.blockType).getMachineProperties();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        IMachineProperties<?> definition = this.getDefinition();
        return definition.getShape(state, reader, pos, context);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        TileBase tile = TileUtil.getTile((IBlockReader)worldIn, pos, TileBase.class);
        if (tile == null) {
            return ActionResultType.FAIL;
        }
        if (TileUtil.isUsableByPlayer(playerIn, tile)) {
            if (!playerIn.func_225608_bj_() && FluidUtil.interactWithFluidHandler((PlayerEntity)playerIn, (Hand)hand, (World)worldIn, (BlockPos)pos, (Direction)hit.func_216354_b())) {
                return ActionResultType.SUCCESS;
            }
            if (!worldIn.field_72995_K) {
                ServerPlayerEntity sPlayer = (ServerPlayerEntity)playerIn;
                tile.openGui(sPlayer, pos);
            }
        }
        return ActionResultType.SUCCESS;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a(FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        super.func_176208_a(world, pos, state, player);
        if (world.field_72995_K) {
            return;
        }
        TileEntity tile = TileUtil.getTile((IBlockReader)world, pos);
        if (tile instanceof IInventory) {
            IInventory inventory = (IInventory)tile;
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)inventory);
        }
        if (tile instanceof TileForestry) {
            ((TileForestry)tile).onRemoval();
        }
        if (tile instanceof ISocketable) {
            InventoryUtil.dropSockets((ISocketable)tile, tile.func_145831_w(), tile.func_174877_v());
        }
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        if (placer instanceof PlayerEntity) {
            TileUtil.actOnTile((IWorldReader)world, pos, IOwnedTile.class, tile -> {
                IOwnerHandler ownerHandler = tile.getOwnerHandler();
                PlayerEntity player = (PlayerEntity)placer;
                GameProfile gameProfile = player.func_146103_bH();
                ownerHandler.setOwner(gameProfile);
            });
        }
    }

    public void clientSetup() {
        ((IBlockType)this.blockType).getMachineProperties().clientSetup();
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        Direction facing = (Direction)state.func_177229_b(FACING);
        return (BlockState)state.func_206870_a(FACING, (Comparable)rot.func_185831_a(facing));
    }

    @Override
    public void registerSprites(ISpriteRegistry registry) {
        IMachineProperties<?> machineProperties = ((IBlockType)this.blockType).getMachineProperties();
        if (machineProperties instanceof IMachinePropertiesTesr) {
            registry.addSprite(((IMachinePropertiesTesr)machineProperties).getParticleTexture());
        }
    }
}

