/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import com.google.common.collect.LinkedListMultimap;
import forestry.core.IResupplyHandler;
import forestry.core.config.Config;
import forestry.core.utils.WorldUtils;
import forestry.modules.ModuleManager;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="forestry")
public class TickHandlerCoreServer {
    private static final LinkedListMultimap<RegistryKey<World>, ChunkCoords> chunkRegenList = LinkedListMultimap.create();
    private static final Set<RegistryKey<World>> checkForRetrogen = new HashSet<RegistryKey<World>>();

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        ServerWorld world;
        RegistryKey dimId;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (Config.enableBackpackResupply) {
            for (PlayerEntity obj : event.world.func_217369_A()) {
                for (IResupplyHandler handler : ModuleManager.resupplyHandlers) {
                    handler.resupply(obj);
                }
            }
        }
        if (Config.doRetrogen && event.world instanceof ServerWorld && checkForRetrogen.contains(dimId = (world = (ServerWorld)event.world).func_234923_W_())) {
            List chunkList = chunkRegenList.get((Object)dimId);
            Iterator iterator = chunkList.iterator();
            while (iterator.hasNext()) {
                ChunkCoords coords = (ChunkCoords)iterator.next();
                if (!TickHandlerCoreServer.canDecorate(world, coords)) continue;
                iterator.remove();
                Random random = TickHandlerCoreServer.getRetrogenRandom((World)world, coords);
            }
            checkForRetrogen.remove(dimId);
        }
    }

    private static Random getRetrogenRandom(World world, ChunkCoords coords) {
        long worldSeed = WorldUtils.asServer((IWorld)world).func_72905_C();
        Random random = new Random(worldSeed);
        long xSeed = random.nextLong() >> 3;
        long zSeed = random.nextLong() >> 3;
        random.setSeed(xSeed * (long)coords.x + zSeed * (long)coords.z ^ worldSeed);
        return random;
    }

    private static boolean canDecorate(ServerWorld server, ChunkCoords chunkCoords) {
        ServerChunkProvider chunkProvider = server.func_72863_F();
        for (int x = 0; x <= 1; ++x) {
            for (int z = 0; z <= 1; ++z) {
                if (chunkProvider.func_73149_a(chunkCoords.x + x, chunkCoords.z + z)) continue;
                return false;
            }
        }
        return true;
    }

    @SubscribeEvent
    public static void chunkSaveEventHandler(ChunkDataEvent.Save event) {
        CompoundNBT tag = new CompoundNBT();
        if (Config.doRetrogen) {
            tag.func_74757_a("retrogen", true);
        }
        event.getData().func_218657_a("forestry", (INBT)tag);
    }

    @SubscribeEvent
    public static void chunkLoadEventHandler(ChunkDataEvent.Load event) {
        CompoundNBT tag;
        CompoundNBT eventData;
        if (Config.doRetrogen && (eventData = event.getData()).func_74764_b("forestry") && (!(tag = eventData.func_74775_l("forestry")).func_74764_b("retrogen") || Config.forceRetrogen)) {
            ChunkCoords coords = new ChunkCoords(event.getChunk());
            chunkRegenList.put(coords.dimension, (Object)coords);
            checkForRetrogen.add(coords.dimension);
        }
    }

    private static class ChunkCoords {
        public final RegistryKey<World> dimension;
        public final int x;
        public final int z;

        public ChunkCoords(IChunk chunk) {
            IWorld world = chunk.getWorldForge();
            if (world == null) {
                this.dimension = World.field_234918_g_;
                this.x = 0;
                this.z = 0;
            } else {
                this.dimension = ((World)world).func_234923_W_();
                this.x = chunk.func_76632_l().field_77276_a;
                this.z = chunk.func_76632_l().field_77275_b;
            }
        }
    }
}

