/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import forestry.core.fluids.ForestryFluids;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="forestry", value={Dist.CLIENT})
public class FluidFogEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onFogColorRender(EntityViewRenderEvent.FogColors event) {
        if (event.getInfo().func_216771_k().func_206886_c() != Fluids.field_204541_a && FluidFogEventHandler.isForestryFluid(event.getInfo().func_216771_k())) {
            Color color = FluidFogEventHandler.getForestryFluid(event.getInfo().func_216771_k()).getParticleColor();
            event.setRed((float)color.getRed() / 255.0f);
            event.setGreen((float)color.getGreen() / 255.0f);
            event.setBlue((float)color.getBlue() / 255.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onFogDenseRender(EntityViewRenderEvent.FogDensity event) {
        if (event.getInfo().func_216771_k().func_206886_c() != Fluids.field_204541_a && FluidFogEventHandler.isForestryFluid(event.getInfo().func_216771_k())) {
            event.setDensity(80.0f);
        }
    }

    public static boolean isForestryFluid(FluidState fluid) {
        return FluidFogEventHandler.getForestryFluid(fluid) != null;
    }

    @Nullable
    public static ForestryFluids getForestryFluid(FluidState fluid) {
        for (ForestryFluids ffluid : ForestryFluids.values()) {
            if (fluid.func_206886_c() != ffluid.getFluid() && fluid.func_206886_c() != ffluid.getFlowing()) continue;
            return ffluid;
        }
        return null;
    }
}

