/*
 * Decompiled with CFR 0.152.
 */
package forestry.climatology.gui.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import forestry.api.climate.IClimateTransformer;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.alleles.IAlleleForestrySpecies;
import forestry.core.climate.ClimateStateHelper;
import forestry.core.gui.elements.GuiElement;
import genetics.api.individual.IIndividual;
import genetics.utils.RootUtils;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SpeciesSelectionElement
extends GuiElement {
    private final IClimateTransformer transformer;

    public SpeciesSelectionElement(int xPos, int yPos, IClimateTransformer transformer) {
        super(xPos, yPos);
        this.setSize(22, 22);
        this.transformer = transformer;
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int mouseButton) {
        float humid;
        float temp;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        ItemStack itemstack = player.field_71071_by.func_70445_o();
        if (itemstack.func_190926_b()) {
            return false;
        }
        Optional<IIndividual> optional = RootUtils.getIndividual(itemstack);
        if (!optional.isPresent()) {
            return false;
        }
        IIndividual individual = optional.get();
        IAlleleForestrySpecies primary = individual.getGenome().getPrimary(IAlleleForestrySpecies.class);
        EnumTemperature temperature = primary.getTemperature();
        EnumHumidity humidity = primary.getHumidity();
        switch (temperature) {
            case HELLISH: {
                temp = 2.0f;
                break;
            }
            case HOT: {
                temp = 1.25f;
                break;
            }
            case WARM: {
                temp = 0.9f;
                break;
            }
            case COLD: {
                temp = 0.15f;
                break;
            }
            case ICY: {
                temp = 0.0f;
                break;
            }
            default: {
                temp = 0.79f;
            }
        }
        switch (humidity) {
            case DAMP: {
                humid = 0.9f;
                break;
            }
            case ARID: {
                humid = 0.2f;
                break;
            }
            default: {
                humid = 0.4f;
            }
        }
        this.transformer.setTarget(ClimateStateHelper.INSTANCE.create(temp, humid));
        return true;
    }

    @Override
    public void drawElement(MatrixStack transform, int mouseX, int mouseY) {
        super.drawElement(transform, mouseX, mouseY);
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(new ResourceLocation("forestry", "textures/gui/habitat_former.png"));
        RenderSystem.enableAlphaTest();
        this.func_238474_b_(transform, 0, 0, 224, 46, 22, 22);
        RenderSystem.disableAlphaTest();
    }

    @Override
    public boolean canMouseOver() {
        return true;
    }
}

