/*
 * Decompiled with CFR 0.152.
 */
package forestry.climatology.gui.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import forestry.api.climate.IClimateState;
import forestry.api.climate.IClimateTransformer;
import forestry.api.core.ForestryAPI;
import forestry.api.core.tooltips.ToolTip;
import forestry.climatology.gui.GuiHabitatFormer;
import forestry.core.climate.ClimateStateHelper;
import forestry.core.gui.elements.GuiElement;
import forestry.core.gui.elements.layouts.ContainerElement;
import forestry.core.render.TextureManagerForestry;
import forestry.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HabitatSelectionElement
extends ContainerElement {
    private static final Comparator<ClimateButton> BUTTON_COMPARATOR = Comparator.comparingDouble(rec$ -> ClimateButton.access$300((ClimateButton)((Object)((Object)rec$))));
    private final List<ClimateButton> buttons = new ArrayList<ClimateButton>();
    private final IClimateTransformer transformer;

    public HabitatSelectionElement(int xPos, int yPos, IClimateTransformer transformer) {
        this.setPos(xPos, yPos);
        this.setSize(60, 40);
        this.transformer = transformer;
        int x = 0;
        int y = 0;
        for (EnumClimate climate : EnumClimate.values()) {
            ClimateButton button = new ClimateButton(climate, x * 20, y * 20);
            this.buttons.add(button);
            this.add(button);
            if (++x < 3) continue;
            ++y;
            x = 0;
        }
    }

    @Override
    public void drawElement(MatrixStack transform, int mouseX, int mouseY) {
        super.drawElement(transform, mouseX, mouseY);
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(new ResourceLocation("forestry", "textures/gui/habitat_former.png"));
        Optional<ClimateButton> optional = this.buttons.stream().min(BUTTON_COMPARATOR);
        if (!optional.isPresent()) {
            return;
        }
        ClimateButton button = optional.get();
        this.func_238474_b_(transform, button.getX() - 1, button.getY() - 1, 0, 233, 22, 22);
    }

    private class ClimateButton
    extends GuiElement {
        final EnumClimate climate;

        private ClimateButton(EnumClimate climate, int xPos, int yPos) {
            super(xPos, yPos);
            this.setSize(20, 20);
            this.climate = climate;
            this.addTooltip((ToolTip tooltip, GuiElement element, int mouseX, int mouseY) -> {
                tooltip.add((ITextComponent)new StringTextComponent("T: " + StringUtil.floatAsPercent(climate.climateState.getTemperature())));
                tooltip.add((ITextComponent)new StringTextComponent("H: " + StringUtil.floatAsPercent(climate.climateState.getHumidity())));
            });
        }

        @Override
        public boolean onMouseClicked(double mouseX, double mouseY, int mouseButton) {
            IClimateState climateState = this.climate.climateState;
            GuiHabitatFormer former = (GuiHabitatFormer)this.getWindow().getGui();
            former.setClimate(climateState);
            former.sendClimateUpdate();
            return true;
        }

        @Override
        public void drawElement(MatrixStack transform, int mouseX, int mouseY) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
            textureManager.func_110577_a(new ResourceLocation("forestry", "textures/gui/habitat_former.png"));
            this.func_238474_b_(transform, 0, 0, 204, 46, 20, 20);
            TextureManagerForestry.getInstance().bindGuiTextureMap();
            ClimateButton.func_238470_a_((MatrixStack)transform, (int)2, (int)2, (int)this.func_230927_p_(), (int)16, (int)16, (TextureAtlasSprite)this.climate.getSprite());
        }

        private double getComparingCode() {
            IClimateState target = HabitatSelectionElement.this.transformer.getTarget();
            IClimateState state = this.climate.climateState;
            double temp = target.getTemperature() - state.getTemperature();
            double hem = target.getHumidity() - state.getHumidity();
            return Math.abs(temp + hem);
        }
    }

    private static enum EnumClimate {

        private IClimateState climateState;
        private String spriteName;

        private EnumClimate(String spriteName, Biome biome) {
            this.climateState = ClimateStateHelper.of(biome.func_242445_k(), biome.func_76727_i());
            this.spriteName = spriteName;
        }

        @OnlyIn(value=Dist.CLIENT)
        public TextureAtlasSprite getSprite() {
            return ForestryAPI.textureManager.getDefault(this.spriteName);
        }
    }
}

