/*
 * Decompiled with CFR 0.152.
 */
package forestry.climatology.gui.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import forestry.api.climate.ClimateType;
import forestry.api.climate.IClimateState;
import forestry.api.climate.IClimateTransformer;
import forestry.api.core.tooltips.ToolTip;
import forestry.climatology.gui.GuiHabitatFormer;
import forestry.core.gui.elements.GuiElement;
import forestry.core.utils.StringUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClimateBarElement
extends GuiElement {
    public static final float MAX_VALUE = 2.0f;
    private final IClimateTransformer transformer;
    private final ClimateType type;
    private boolean dragging;

    public ClimateBarElement(int xPos, int yPos, IClimateTransformer transformer, ClimateType type) {
        super(xPos, yPos);
        this.setSize(52, 12);
        this.transformer = transformer;
        this.type = type;
        this.addTooltip((ToolTip tooltip, GuiElement element, int mouseX, int mouseY) -> {
            IClimateState targetedState = transformer.getTarget();
            IClimateState state = transformer.getCurrent();
            IClimateState defaultState = transformer.getDefault();
            tooltip.add((ITextComponent)new TranslationTextComponent("for.gui.habitat_former.climate.target", new Object[]{StringUtil.floatAsPercent(targetedState.getClimate(type))}));
            tooltip.add((ITextComponent)new TranslationTextComponent("for.gui.habitat_former.climate.value", new Object[]{StringUtil.floatAsPercent(state.getClimate(type))}));
            tooltip.add((ITextComponent)new TranslationTextComponent("for.gui.habitat_former.climate.default", new Object[]{StringUtil.floatAsPercent(defaultState.getClimate(type))}));
        });
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (Screen.func_231172_r_()) {
            GuiHabitatFormer former = (GuiHabitatFormer)this.getWindow().getGui();
            IClimateState climateState = former.getClimate();
            IClimateState newState = climateState.toImmutable().setClimate(this.type, this.transformer.getDefault().getTemperature());
            former.setClimate(newState);
            former.sendClimateUpdate();
            return true;
        }
        this.dragging = true;
        return this.handleMouse((int)mouseX, (int)mouseY);
    }

    @Override
    public boolean onMouseReleased(double mouseX, double mouseY, int mouseButton) {
        if (!this.dragging) {
            return false;
        }
        this.dragging = false;
        GuiHabitatFormer former = (GuiHabitatFormer)this.getWindow().getGui();
        former.sendClimateUpdate();
        return true;
    }

    @Override
    public void drawElement(MatrixStack transform, int mouseX, int mouseY) {
        this.handleMouse(mouseY - this.getX(), mouseX - this.getY());
        RenderSystem.enableAlphaTest();
        GuiHabitatFormer gui = (GuiHabitatFormer)this.getWindow().getGui();
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(gui.textureFile);
        ClimateBarElement.setGLColorFromInt(this.type == ClimateType.TEMPERATURE ? 16766720 : 0x7FF4F4);
        int progressScaled = this.getProgressScaled();
        this.func_238474_b_(transform, 1, 1, 177, 69, progressScaled, 10);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_238474_b_(transform, 1 + this.getDefaultPosition(), 1, 232 + (this.type == ClimateType.TEMPERATURE ? 3 : 0), 69, 1, 10);
        this.func_238474_b_(transform, 1 + this.getPointerPosition(), 1, 229, 69, 1, 10);
        this.func_238474_b_(transform, 1, 1, 177, 80, 50, 10);
        RenderSystem.disableAlphaTest();
    }

    private int getProgressScaled() {
        float value = this.transformer.getCurrent().getClimate(this.type);
        return (int)(value * (float)(this.preferredSize.width - 2) / 2.0f);
    }

    private int getPointerPosition() {
        float targetedValue = this.transformer.getTarget().getClimate(this.type);
        return (int)(targetedValue * 49.0f / 2.0f);
    }

    private int getDefaultPosition() {
        float value = this.transformer.getDefault().getClimate(this.type);
        return (int)(value * 49.0f / 2.0f);
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.color4f((float)red, (float)green, (float)blue, (float)1.0f);
    }

    private boolean handleMouse(int mouseX, int mouseY) {
        if (!this.dragging) {
            return false;
        }
        if (mouseX < 1 || mouseY < 1 || mouseX > this.preferredSize.width - 1 || mouseY > this.preferredSize.height - 1) {
            return false;
        }
        float quotient = MathHelper.func_76131_a((float)((float)(mouseX - 1) / (float)(this.preferredSize.width - 3)), (float)0.0f, (float)1.0f);
        float value = 2.0f * quotient;
        GuiHabitatFormer former = (GuiHabitatFormer)this.getWindow().getGui();
        IClimateState climateState = former.getClimate();
        IClimateState newState = climateState.toImmutable().setClimate(this.type, value);
        former.setClimate(newState);
        return true;
    }
}

