/*
 * Decompiled with CFR 0.152.
 */
package forestry.climatology.blocks;

import forestry.api.core.EnumTemperature;
import forestry.climatology.blocks.BlockTypeClimatology;
import forestry.climatology.tiles.TileHabitatFormer;
import forestry.core.blocks.BlockBase;
import forestry.core.blocks.IColoredBlock;
import forestry.core.render.ParticleRender;
import forestry.core.tiles.TileUtil;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class BlockHabitatFormer
extends BlockBase<BlockTypeClimatology>
implements IColoredBlock {
    public BlockHabitatFormer() {
        super(BlockTypeClimatology.HABITAT_FORMER, AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(1.0f).harvestTool(ToolType.AXE).harvestLevel(0));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileHabitatFormer former = TileUtil.getTile((IBlockReader)worldIn, pos, TileHabitatFormer.class);
        if (former != null) {
            ParticleRender.addClimateParticles(worldIn, pos, rand, former.getTemperature(), former.getHumidity());
        }
    }

    @Override
    public int colorMultiplier(BlockState state, @Nullable IBlockReader worldIn, @Nullable BlockPos pos, int tintIndex) {
        if (worldIn == null || pos == null) {
            return 9511479;
        }
        TileHabitatFormer former = TileUtil.getTile(worldIn, pos, TileHabitatFormer.class);
        if (former != null) {
            EnumTemperature temperature = former.getTemperature();
            return temperature.color;
        }
        return 9511479;
    }
}

