/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.proxy;

import forestry.api.arboriculture.genetics.IAlleleFruit;
import forestry.api.arboriculture.genetics.TreeChromosomes;
import forestry.arboriculture.features.ArboricultureBlocks;
import forestry.arboriculture.genetics.alleles.AlleleFruits;
import forestry.arboriculture.models.ModelDecorativeLeaves;
import forestry.arboriculture.models.ModelDefaultLeaves;
import forestry.arboriculture.models.ModelDefaultLeavesFruit;
import forestry.arboriculture.models.ModelLeaves;
import forestry.arboriculture.models.SaplingModelLoader;
import forestry.arboriculture.models.TextureLeaves;
import forestry.arboriculture.proxy.ProxyArboriculture;
import forestry.core.models.ClientManager;
import forestry.modules.IClientModuleHandler;
import genetics.utils.AlleleUtils;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.FoliageColors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@OnlyIn(value=Dist.CLIENT)
public class ProxyArboricultureClient
extends ProxyArboriculture
implements IClientModuleHandler {
    @Override
    public void initializeModels() {
        ClientManager clientManager = ClientManager.getInstance();
        clientManager.registerModel((IBakedModel)new ModelLeaves(), ArboricultureBlocks.LEAVES);
        clientManager.registerModel((IBakedModel)new ModelDecorativeLeaves(), ArboricultureBlocks.LEAVES_DECORATIVE);
        clientManager.registerModel((IBakedModel)new ModelDefaultLeaves(), ArboricultureBlocks.LEAVES_DEFAULT);
        clientManager.registerModel((IBakedModel)new ModelDefaultLeavesFruit(), ArboricultureBlocks.LEAVES_DEFAULT_FRUIT);
    }

    @Override
    public int getFoliageColorDefault() {
        return FoliageColors.func_77468_c();
    }

    @Override
    public int getFoliageColorBirch() {
        return FoliageColors.func_77469_b();
    }

    @Override
    public int getFoliageColorSpruce() {
        return FoliageColors.func_77466_a();
    }

    @Override
    public void registerSprites(TextureStitchEvent.Pre event) {
        if (event.getMap().func_229223_g_() != PlayerContainer.field_226615_c_) {
            return;
        }
        TextureLeaves.registerAllSprites(event);
        for (IAlleleFruit alleleFruit : AlleleFruits.getFruitAlleles()) {
            alleleFruit.getProvider().registerSprites(event);
        }
    }

    @Override
    public void setupClient(FMLClientSetupEvent event) {
        ArboricultureBlocks.LEAVES_DEFAULT.getBlocks().forEach(block -> RenderTypeLookup.setRenderLayer((Block)block, (RenderType)RenderType.func_228641_d_()));
        RenderTypeLookup.setRenderLayer(ArboricultureBlocks.LEAVES.block(), (RenderType)RenderType.func_228641_d_());
        ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.getBlocks().forEach(block -> RenderTypeLookup.setRenderLayer((Block)block, (RenderType)RenderType.func_228641_d_()));
        ArboricultureBlocks.LEAVES_DECORATIVE.getBlocks().forEach(block -> RenderTypeLookup.setRenderLayer((Block)block, (RenderType)RenderType.func_228641_d_()));
        RenderTypeLookup.setRenderLayer(ArboricultureBlocks.SAPLING_GE.block(), (RenderType)RenderType.func_228643_e_());
        ArboricultureBlocks.DOORS.getBlocks().forEach(block -> RenderTypeLookup.setRenderLayer((Block)block, (RenderType)RenderType.func_228645_f_()));
        AlleleUtils.forEach(TreeChromosomes.SPECIES, treeSpecies -> {
            ModelLoader.addSpecialModel((ResourceLocation)treeSpecies.getBlockModel());
            ModelLoader.addSpecialModel((ResourceLocation)treeSpecies.getItemModel());
        });
    }

    @Override
    public void registerModels(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("forestry", "sapling_ge"), (IModelLoader)SaplingModelLoader.INSTANCE);
    }
}

