/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.models;

import forestry.api.arboriculture.genetics.ITree;
import forestry.arboriculture.blocks.BlockForestryLeaves;
import forestry.arboriculture.genetics.TreeHelper;
import forestry.arboriculture.tiles.TileLeaves;
import forestry.core.models.ModelBlockCached;
import forestry.core.models.baker.ModelBaker;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ResourceUtil;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public class ModelLeaves
extends ModelBlockCached<BlockForestryLeaves, Key> {
    @Override
    protected Key getInventoryKey(ItemStack itemStack) {
        TileLeaves leaves = new TileLeaves();
        if (itemStack.func_77978_p() != null) {
            leaves.func_230337_a_(leaves.func_195044_w(), itemStack.func_77978_p());
        } else {
            leaves.setTree((ITree)TreeHelper.getRoot().getIndividualTemplates().get(0));
        }
        return this.getKey(leaves.getModelData());
    }

    @Override
    protected Key getWorldKey(BlockState state, IModelData extraData) {
        return this.getKey(extraData);
    }

    private Key getKey(IModelData extraData) {
        boolean fancy = Proxies.render.fancyGraphicsEnabled();
        ResourceLocation leafLocation = TileLeaves.getLeaveSprite(extraData, fancy);
        ResourceLocation fruitLocation = TileLeaves.getFruitSprite(extraData);
        return new Key(ResourceUtil.getBlockSprite(leafLocation), fruitLocation != null ? ResourceUtil.getBlockSprite(fruitLocation) : null, fancy);
    }

    @Override
    protected void bakeBlock(BlockForestryLeaves block, IModelData extraData, Key key, ModelBaker baker, boolean inventory) {
        baker.addBlockModel(key.leafSprite, 0);
        if (key.fruitSprite != null) {
            baker.addBlockModel(key.fruitSprite, 2);
        }
        baker.setParticleSprite(key.leafSprite);
    }

    public ModelLeaves() {
        super(BlockForestryLeaves.class);
    }

    public static class Key {
        public final TextureAtlasSprite leafSprite;
        @Nullable
        public final TextureAtlasSprite fruitSprite;
        public final boolean fancy;
        private final int hashCode;

        public Key(TextureAtlasSprite leafSprite, @Nullable TextureAtlasSprite fruitSprite, boolean fancy) {
            this.leafSprite = leafSprite;
            this.fruitSprite = fruitSprite;
            this.fancy = fancy;
            this.hashCode = Objects.hash(leafSprite, fruitSprite, fancy);
        }

        public boolean equals(Object other) {
            if (!(other instanceof Key)) {
                return false;
            }
            Key otherKey = (Key)other;
            return otherKey.leafSprite == this.leafSprite && otherKey.fruitSprite == this.fruitSprite && otherKey.fancy == this.fancy;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

