/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.EnumForestryWoodType;
import forestry.api.arboriculture.EnumFruitFamily;
import forestry.api.arboriculture.EnumLeafType;
import forestry.api.arboriculture.EnumVanillaWoodType;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.IGermlingModelProvider;
import forestry.api.arboriculture.ILeafSpriteProvider;
import forestry.api.arboriculture.ITreeGenData;
import forestry.api.arboriculture.ITreeGenerator;
import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.api.arboriculture.genetics.EnumGermlingType;
import forestry.api.arboriculture.genetics.IAlleleTreeSpecies;
import forestry.api.arboriculture.genetics.IAlleleTreeSpeciesBuilder;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.arboriculture.genetics.ITreeMutationBuilder;
import forestry.api.arboriculture.genetics.TreeChromosomes;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IBlockSubtype;
import forestry.arboriculture.blocks.BlockAbstractLeaves;
import forestry.arboriculture.features.ArboricultureBlocks;
import forestry.arboriculture.genetics.ITreeDefinition;
import forestry.arboriculture.genetics.LeafProvider;
import forestry.arboriculture.genetics.Tree;
import forestry.arboriculture.genetics.TreeBranchDefinition;
import forestry.arboriculture.genetics.alleles.AlleleFruits;
import forestry.arboriculture.models.ModelProviderFactory;
import forestry.arboriculture.tiles.TileLeaves;
import forestry.arboriculture.worldgen.FeatureAcacia;
import forestry.arboriculture.worldgen.FeatureAcaciaVanilla;
import forestry.arboriculture.worldgen.FeatureBalsa;
import forestry.arboriculture.worldgen.FeatureBaobab;
import forestry.arboriculture.worldgen.FeatureBirch;
import forestry.arboriculture.worldgen.FeatureCherry;
import forestry.arboriculture.worldgen.FeatureChestnut;
import forestry.arboriculture.worldgen.FeatureCocobolo;
import forestry.arboriculture.worldgen.FeatureDarkOak;
import forestry.arboriculture.worldgen.FeatureDate;
import forestry.arboriculture.worldgen.FeatureEbony;
import forestry.arboriculture.worldgen.FeatureGiganteum;
import forestry.arboriculture.worldgen.FeatureGreenheart;
import forestry.arboriculture.worldgen.FeatureIpe;
import forestry.arboriculture.worldgen.FeatureJungle;
import forestry.arboriculture.worldgen.FeatureKapok;
import forestry.arboriculture.worldgen.FeatureLarch;
import forestry.arboriculture.worldgen.FeatureLemon;
import forestry.arboriculture.worldgen.FeatureMahoe;
import forestry.arboriculture.worldgen.FeatureMahogany;
import forestry.arboriculture.worldgen.FeatureMaple;
import forestry.arboriculture.worldgen.FeatureOak;
import forestry.arboriculture.worldgen.FeaturePadauk;
import forestry.arboriculture.worldgen.FeaturePapaya;
import forestry.arboriculture.worldgen.FeaturePine;
import forestry.arboriculture.worldgen.FeaturePlum;
import forestry.arboriculture.worldgen.FeaturePoplar;
import forestry.arboriculture.worldgen.FeatureSequoia;
import forestry.arboriculture.worldgen.FeatureSilverLime;
import forestry.arboriculture.worldgen.FeatureSpruce;
import forestry.arboriculture.worldgen.FeatureTeak;
import forestry.arboriculture.worldgen.FeatureWalnut;
import forestry.arboriculture.worldgen.FeatureWenge;
import forestry.arboriculture.worldgen.FeatureWillow;
import forestry.arboriculture.worldgen.FeatureZebrawood;
import forestry.core.genetics.TemplateMatcher;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.core.tiles.TileUtil;
import forestry.modules.features.FeatureBlock;
import forestry.modules.features.FeatureBlockGroup;
import genetics.api.alleles.IAlleleRegistry;
import genetics.api.alleles.IAlleleTemplate;
import genetics.api.alleles.IAlleleTemplateBuilder;
import genetics.api.individual.IGenome;
import genetics.api.root.ITemplateContainer;
import genetics.api.root.components.ComponentKey;
import genetics.api.root.components.ComponentKeys;
import genetics.api.root.components.IRootComponent;
import java.awt.Color;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public enum TreeDefinition implements ITreeDefinition,
ITreeGenerator,
IBlockSubtype
{
    Oak(TreeBranchDefinition.QUERCUS, "appleOak", "robur", false, EnumLeafType.DECIDUOUS, new Color(4764952), new Color(4764952).brighter(), EnumVanillaWoodType.OAK){

        @Override
        public Feature<NoFeatureConfig> getTreeFeature(ITreeGenData tree) {
            return new FeatureOak(tree);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(TreeChromosomes.FRUITS, AlleleFruits.fruitApple);
            template.set(TreeChromosomes.FERTILITY, EnumAllele.Saplings.AVERAGE);
            template.set(TreeChromosomes.MATURATION, EnumAllele.Maturation.FASTER);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.POMES);
        }

        @Override
        protected void registerMutations() {
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    DarkOak(TreeBranchDefinition.QUERCUS, "darkOak", "velutina", false, EnumLeafType.DECIDUOUS, new Color(4764952), new Color(4764952).brighter(), EnumVanillaWoodType.DARK_OAK){

        @Override
        public Feature<NoFeatureConfig> getTreeFeature(ITreeGenData tree) {
            return new FeatureDarkOak(tree);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(TreeChromosomes.FERTILITY, EnumAllele.Saplings.AVERAGE);
            template.set(TreeChromosomes.MATURATION, EnumAllele.Maturation.FASTER);
            template.set(TreeChromosomes.GIRTH, 2);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.POMES);
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    Birch(TreeBranchDefinition.BETULA, "silverBirch", "pendula", false, EnumLeafType.DECIDUOUS, new Color(8431445), new Color(11585096), EnumVanillaWoodType.BIRCH){

        @Override
        public Feature<NoFeatureConfig> getTreeFeature(ITreeGenData tree) {
            return new FeatureBirch(tree);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(TreeChromosomes.FERTILITY, EnumAllele.Saplings.AVERAGE);
            template.set(TreeChromosomes.MATURATION, EnumAllele.Maturation.FASTER);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    Lime(TreeBranchDefinition.TILIA, "silverLime", "pendula", true, EnumLeafType.DECIDUOUS, new Color(6201607), new Color(6201607).brighter(), EnumForestryWoodType.LIME){

        @Override
        public Feature<NoFeatureConfig> getTreeFeature(ITreeGenData tree) {
            return new FeatureSilverLime(tree);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(TreeChromosomes.FERTILITY, EnumAllele.Saplings.LOW);
            template.set(TreeChromosomes.SAPPINESS, EnumAllele.Sappiness.LOWER);
            template.set(TreeChromosomes.YIELD, EnumAllele.Yield.LOWER);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.NUX).addFruitFamily(EnumFruitFamily.PRUNES).addFruitFamily(EnumFruitFamily.POMES).setRarity(0.005f);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Birch, Oak, 15);
        }
    }
    ,
    Walnut(TreeBranchDefinition.JUGLANS, "commonWalnut", "regia", true, EnumLeafType.DECIDUOUS, new Color(7965781), new Color(11585096), EnumForestryWoodType.WALNUT){

        @Override
        public Feature<NoFeatureConfig> getTreeFeature(ITreeGenData tree) {
            return new FeatureWalnut(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.NUX).addFruitFamily(EnumFruitFamily.PRUNES).addFruitFamily(EnumFruitFamily.POMES);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(TreeChromosomes.FRUITS, AlleleFruits.fruitWalnut);
            template.set(TreeChromosomes.FERTILITY, EnumAllele.Saplings.LOWER);
            template.set(TreeChromosomes.YIELD, EnumAllele.Yield.AVERAGE);
            template.set(TreeChromosomes.SAPPINESS, EnumAllele.Sappiness.LOWER);
            template.set(TreeChromosomes.HEIGHT, EnumAllele.Height.AVERAGE);
            template.set(TreeChromosomes.GIRTH, 2);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Lime, Cherry, 10);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Chestnut(TreeBranchDefinition.CASTANEA, "sweetChestnut", "sativa", true, EnumLeafType.DECIDUOUS, new Color(6201607), new Color(11585096), EnumForestryWoodType.CHESTNUT){

        @Override
        public Feature<NoFeatureConfig> getTreeFeature(ITreeGenData tree) {
            return new FeatureChestnut(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.NUX).addFruitFamily(EnumFruitFamily.PRUNES).addFruitFamily(EnumFruitFamily.POMES);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(TreeChromosomes.FRUITS, AlleleFruits.fruitChestnut);
            template.set(TreeChromosomes.YIELD, EnumAllele.Yield.AVERAGE);
            template.set(TreeChromosomes.SAPPINESS, EnumAllele.Sappiness.LOWER);
            template.set(TreeChromosomes.HEIGHT, EnumAllele.Height.LARGE);
            template.set(TreeChromosomes.GIRTH, 2);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Walnut, Lime, 10);
            this.registerMutation(Walnut, Cherry, 10);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Cherry(TreeBranchDefinition.PRUNUS, "hillCherry", "serrulata", true, EnumLeafType.DECIDUOUS, new Color(15110618), new Color(15089241), EnumForestryWoodType.CHERRY){

        @Override
        public Feature<NoFeatureConfig> getTreeFeature(ITreeGenData tree) {
            return new FeatureCherry(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.PRUNES).addFruitFamily(EnumFruitFamily.POMES).setRarity(0.0015f);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(TreeChromosomes.FRUITS, AlleleFruits.fruitCherry);
            template.set(TreeChromosomes.FERTILITY, EnumAllele.Saplings.LOW);
            template.set(TreeChromosomes.YIELD, EnumAllele.Yield.AVERAGE);
            template.set(TreeChromosomes.SAPPINESS, EnumAllele.Sappiness.LOW);
            template.set(TreeChromosomes.HEIGHT, EnumAllele.Height.SMALLER);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Lime, Oak, 10);
            this.registerMutation(Lime, Birch, 10);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Lemon(TreeBranchDefinition.CITRUS, "lemon", "limon", true, EnumLeafType.DECIDUOUS, new Color(8957780), new Color(10729552), EnumForestryWoodType.CITRUS){

        @Override
        public Feature<NoFeatureConfig> getTreeFeature(ITreeGenData tree) {
            return new FeatureLemon(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.PRUNES).addFruitFamily(EnumFruitFamily.POMES);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(TreeChromosomes.FRUITS, AlleleFruits.fruitLemon);
            template.set(TreeChromosomes.YIELD, EnumAllele.Yield.LOWER);
            template.set(TreeChromosomes.SAPPINESS, EnumAllele.Sappiness.AVERAGE);
            template.set(TreeChromosomes.HEIGHT, EnumAllele.Height.SMALLEST);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Lime, Cherry, 5);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Plum(TreeBranchDefinition.PRUNUS, "plum", "domestica", true, EnumLeafType.DECIDUOUS, new Color(5804614), new Color(10729552), EnumForestryWoodType.PLUM){

        @Override
        public Feature<NoFeatureConfig> getTreeFeature(ITreeGenData tree) {
            return new FeaturePlum(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            ((IAlleleTreeSpeciesBuilder)treeSpecies.addFruitFamily(EnumFruitFamily.PRUNES).addFruitFamily(EnumFruitFamily.POMES).setRarity(0.005f).setTemperature(EnumTemperature.WARM)).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(TreeChromosomes.FRUITS, AlleleFruits.fruitPlum);
            template.set(TreeChromosomes.YIELD, EnumAllele.Yield.HIGH);
            template.set(TreeChromosomes.SAPPINESS, EnumAllele.Sappiness.AVERAGE);
            template.set(TreeChromosomes.HEIGHT, EnumAllele.Height.SMALLEST);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Lemon, Cherry, 5);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Maple(TreeBranchDefinition.ACER, "sugarMaple", "saccharum", true, EnumLeafType.MAPLE, new Color(13956133), new Color(6396476), EnumForestryWoodType.MAPLE){

        @Override
        public Feature<NoFeatureConfig> getTreeFeature(ITreeGenData tree) {
            return new FeatureMaple(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.PRUNES).addFruitFamily(EnumFruitFamily.POMES).setRarity(0.0025f);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(TreeChromosomes.FERTILITY, EnumAllele.Saplings.LOW);
            template.set(TreeChromosomes.SAPPINESS, EnumAllele.Sappiness.LOWER);
            template.set(TreeChromosomes.HEIGHT, EnumAllele.Height.AVERAGE);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Spruce, Larch, 5);
        }
    }
    ,
    Spruce(TreeBranchDefinition.PICEA, "redSpruce", "abies", false, EnumLeafType.CONIFERS, new Color(0x619961), new Color(5479698), EnumVanillaWoodType.SPRUCE){

        @Override
        public Feature<NoFeatureConfig> getTreeFeature(ITreeGenData tree) {
            return new FeatureSpruce(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(TreeChromosomes.FERTILITY, EnumAllele.Saplings.AVERAGE);
            template.set(TreeChromosomes.HEIGHT, EnumAllele.Height.AVERAGE);
            template.set(TreeChromosomes.MATURATION, EnumAllele.Maturation.FASTER);
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    Larch(TreeBranchDefinition.LARIX, "mundaneLarch", "decidua", true, EnumLeafType.CONIFERS, new Color(6918032), new Color(5675158), EnumForestryWoodType.LARCH){

        @Override
        public Feature<NoFeatureConfig> getTreeFeature(ITreeGenData tree) {
            return new FeatureLarch(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.setRarity(0.0025f).setTemperature(EnumTemperature.COLD);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(TreeChromosomes.FERTILITY, EnumAllele.Saplings.LOW);
            template.set(TreeChromosomes.SAPPINESS, EnumAllele.Sappiness.LOWER);
            template.set(TreeChromosomes.HEIGHT, EnumAllele.Height.AVERAGE);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Spruce, Birch, 10);
            this.registerMutation(Spruce, Oak, 10);
        }
    }
    ,
    Pine(TreeBranchDefinition.PINUS, "bullPine", "sabiniana", true, EnumLeafType.CONIFERS, new Color(0xFEFF8F), new Color(16767375), EnumForestryWoodType.PINE){

        @Override
        public Feature<NoFeatureConfig> getTreeFeature(ITreeGenData tree) {
            return new FeaturePine(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.setRarity(0.0025f).setTemperature(EnumTemperature.COLD);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(TreeChromosomes.FERTILITY, EnumAllele.Saplings.LOW);
            template.set(TreeChromosomes.SAPPINESS, EnumAllele.Sappiness.LOWER);
            template.set(TreeChromosomes.HEIGHT, EnumAllele.Height.AVERAGE);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Spruce, Larch, 10);
        }
    }
    ,
    Sequoia(TreeBranchDefinition.SEQUOIA, "coastSequoia", "sempervirens", false, EnumLeafType.CONIFERS, new Color(4296305), new Color(5675158), EnumForestryWoodType.SEQUOIA){

        @Override
        public Feature<NoFeatureConfig> getTreeFeature(ITreeGenData tree) {
            return new FeatureSequoia(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(TreeChromosomes.HEIGHT, EnumAllele.Height.LARGEST);
            template.set(TreeChromosomes.SAPPINESS, EnumAllele.Sappiness.LOWER);
            template.set(TreeChromosomes.MATURATION, EnumAllele.Maturation.SLOWER);
            template.set(TreeChromosomes.GIRTH, 3);
            template.set(TreeChromosomes.FIREPROOF, EnumAllele.Fireproof.TRUE);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Larch, Pine, 5);
        }
    }
    ,
    Gigant(TreeBranchDefinition.SEQUOIADENDRON, "giantSequoia", "giganteum", false, EnumLeafType.CONIFERS, new Color(7570484), new Color(7570484).brighter(), EnumForestryWoodType.GIGANTEUM){

        @Override
        public Feature<NoFeatureConfig> getTreeFeature(ITreeGenData tree) {
            return new FeatureGiganteum(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.setComplexity(10);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(TreeChromosomes.HEIGHT, EnumAllele.Height.GIGANTIC);
            template.set(TreeChromosomes.SAPPINESS, EnumAllele.Sappiness.LOWEST);
            template.set(TreeChromosomes.MATURATION, EnumAllele.Maturation.SLOWEST);
            template.set(TreeChromosomes.GIRTH, 4);
            template.set(TreeChromosomes.FIREPROOF, EnumAllele.Fireproof.TRUE);
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    Jungle(TreeBranchDefinition.TROPICAL, "jungle", "tectona", false, EnumLeafType.JUNGLE, new Color(4764952), new Color(6654231), EnumVanillaWoodType.JUNGLE){

        @Override
        public Feature<NoFeatureConfig> getTreeFeature(ITreeGenData tree) {
            return new FeatureJungle(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.JUNGLE);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(TreeChromosomes.FRUITS, AlleleFruits.fruitCocoa);
            template.set(TreeChromosomes.HEIGHT, EnumAllele.Height.LARGER);
            template.set(TreeChromosomes.MATURATION, EnumAllele.Maturation.FAST);
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    Teak(TreeBranchDefinition.TECTONA, "teak", "grandis", true, EnumLeafType.JUNGLE, new Color(0xFEFF8F), new Color(16767375), EnumForestryWoodType.TEAK){

        @Override
        public Feature<NoFeatureConfig> getTreeFeature(ITreeGenData tree) {
            return new FeatureTeak(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            ((IAlleleTreeSpeciesBuilder)treeSpecies.addFruitFamily(EnumFruitFamily.JUNGLE).setRarity(0.0025f).setTemperature(EnumTemperature.WARM)).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(TreeChromosomes.SAPPINESS, EnumAllele.Sappiness.LOWER);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(DarkOak, Jungle, 10);
        }
    }
    ,
    Ipe(TreeBranchDefinition.TABEBUIA, "ipe", "serratifolia", true, EnumLeafType.JUNGLE, new Color(16634375), new Color(11374340), EnumForestryWoodType.IPE){

        @Override
        public Feature<NoFeatureConfig> getTreeFeature(ITreeGenData tree) {
            return new FeatureIpe(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.JUNGLE);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(TreeChromosomes.SAPPINESS, EnumAllele.Sappiness.LOWER);
            template.set(TreeChromosomes.HEIGHT, EnumAllele.Height.LARGE);
            template.set(TreeChromosomes.GIRTH, 2);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Teak, DarkOak, 10);
        }
    }
    ,
    Kapok(TreeBranchDefinition.CEIBA, "kapok", "pentandra", true, EnumLeafType.JUNGLE, new Color(9017467), new Color(9022110), EnumForestryWoodType.KAPOK){

        @Override
        public Feature<NoFeatureConfig> getTreeFeature(ITreeGenData tree) {
            return new FeatureKapok(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.JUNGLE).addFruitFamily(EnumFruitFamily.PRUNES);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(TreeChromosomes.HEIGHT, EnumAllele.Height.LARGE);
            template.set(TreeChromosomes.SAPPINESS, EnumAllele.Sappiness.LOW);
            template.set(TreeChromosomes.MATURATION, EnumAllele.Maturation.SLOW);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Jungle, Teak, 10);
        }
    }
    ,
    Ebony(TreeBranchDefinition.EBONY, "myrtleEbony", "pentamera", true, EnumLeafType.JUNGLE, new Color(10670666), new Color(12898890), EnumForestryWoodType.EBONY){

        @Override
        public Feature<NoFeatureConfig> getTreeFeature(ITreeGenData tree) {
            return new FeatureEbony(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            ((IAlleleTreeSpeciesBuilder)treeSpecies.addFruitFamily(EnumFruitFamily.JUNGLE).addFruitFamily(EnumFruitFamily.PRUNES).setRarity(5.0E-4f).setTemperature(EnumTemperature.WARM)).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(TreeChromosomes.HEIGHT, EnumAllele.Height.AVERAGE);
            template.set(TreeChromosomes.SAPPINESS, EnumAllele.Sappiness.LOW);
            template.set(TreeChromosomes.MATURATION, EnumAllele.Maturation.SLOWER);
            template.set(TreeChromosomes.GIRTH, 3);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(DarkOak, Kapok, 10);
        }
    }
    ,
    Zebrawood(TreeBranchDefinition.ASTRONIUM, "zebrawood", "graveolens", false, EnumLeafType.JUNGLE, new Color(10670666), new Color(12898890), EnumForestryWoodType.ZEBRAWOOD){

        @Override
        public Feature<NoFeatureConfig> getTreeFeature(ITreeGenData tree) {
            return new FeatureZebrawood(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            ((IAlleleTreeSpeciesBuilder)treeSpecies.addFruitFamily(EnumFruitFamily.NUX).setRarity(5.0E-4f).setTemperature(EnumTemperature.WARM)).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(TreeChromosomes.HEIGHT, EnumAllele.Height.LARGE);
            template.set(TreeChromosomes.GIRTH, 2);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Ebony, Poplar, 5);
        }
    }
    ,
    Mahogony(TreeBranchDefinition.MAHOGANY, "yellowMeranti", "gibbosa", true, EnumLeafType.JUNGLE, new Color(9089364), new Color(11120980), EnumForestryWoodType.MAHOGANY){

        @Override
        public Feature<NoFeatureConfig> getTreeFeature(ITreeGenData tree) {
            return new FeatureMahogany(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            ((IAlleleTreeSpeciesBuilder)treeSpecies.addFruitFamily(EnumFruitFamily.JUNGLE).setRarity(5.0E-4f).setTemperature(EnumTemperature.WARM)).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(TreeChromosomes.HEIGHT, EnumAllele.Height.LARGE);
            template.set(TreeChromosomes.SAPPINESS, EnumAllele.Sappiness.LOW);
            template.set(TreeChromosomes.MATURATION, EnumAllele.Maturation.SLOW);
            template.set(TreeChromosomes.GIRTH, 2);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Kapok, Ebony, 10);
        }
    }
    ,
    AcaciaVanilla(TreeBranchDefinition.ACACIA, "acacia", "aneura", true, EnumLeafType.DECIDUOUS, new Color(0x616101), new Color(11776770), EnumVanillaWoodType.ACACIA){

        @Override
        public Feature<NoFeatureConfig> getTreeFeature(ITreeGenData tree) {
            return new FeatureAcaciaVanilla(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.JUNGLE).addFruitFamily(EnumFruitFamily.NUX);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    Acacia(TreeBranchDefinition.ACACIA, "desertAcacia", "erioloba", true, EnumLeafType.DECIDUOUS, new Color(7638044), new Color(11776770), EnumForestryWoodType.ACACIA_DESERT){

        @Override
        public Feature<NoFeatureConfig> getTreeFeature(ITreeGenData tree) {
            return new FeatureAcacia(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            ((IAlleleTreeSpeciesBuilder)treeSpecies.addFruitFamily(EnumFruitFamily.JUNGLE).addFruitFamily(EnumFruitFamily.NUX).setRarity(0.005f).setTemperature(EnumTemperature.WARM)).setHumidity(EnumHumidity.ARID);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Teak, Balsa, 10);
        }
    }
    ,
    Padauk(TreeBranchDefinition.PTEROCARPUS, "padauk", "soyauxii", true, EnumLeafType.DECIDUOUS, new Color(13688716), new Color(4414514), EnumForestryWoodType.PADAUK){

        @Override
        public Feature<NoFeatureConfig> getTreeFeature(ITreeGenData tree) {
            return new FeaturePadauk(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.JUNGLE).setRarity(0.005f).setTemperature(EnumTemperature.WARM);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(TreeChromosomes.SAPPINESS, EnumAllele.Sappiness.LOWER);
            template.set(TreeChromosomes.HEIGHT, EnumAllele.Height.LARGE);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(AcaciaVanilla, Jungle, 10);
        }
    }
    ,
    Balsa(TreeBranchDefinition.OCHROMA, "balsa", "pyramidale", true, EnumLeafType.DECIDUOUS, new Color(5876736), new Color(0xFEFF8F), EnumForestryWoodType.BALSA){

        @Override
        public Feature<NoFeatureConfig> getTreeFeature(ITreeGenData tree) {
            return new FeatureBalsa(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            ((IAlleleTreeSpeciesBuilder)treeSpecies.addFruitFamily(EnumFruitFamily.JUNGLE).addFruitFamily(EnumFruitFamily.NUX).setRarity(5.0E-4f).setHumidity(EnumHumidity.DAMP)).setTemperature(EnumTemperature.WARM);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(TreeChromosomes.FERTILITY, EnumAllele.Saplings.HIGH);
            template.set(TreeChromosomes.SAPPINESS, EnumAllele.Sappiness.LOWER);
            template.set(TreeChromosomes.HEIGHT, EnumAllele.Height.LARGE);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Teak, AcaciaVanilla, 10);
        }
    }
    ,
    Cocobolo(TreeBranchDefinition.DALBERGIA, "cocobolo", "retusa", false, EnumLeafType.DECIDUOUS, new Color(6988154), new Color(4750668), EnumForestryWoodType.COCOBOLO){

        @Override
        public Feature<NoFeatureConfig> getTreeFeature(ITreeGenData tree) {
            return new FeatureCocobolo(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.JUNGLE).setRarity(5.0E-4f).setTemperature(EnumTemperature.WARM);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(TreeChromosomes.HEIGHT, EnumAllele.Height.LARGEST);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Acacia, DarkOak, 10);
        }
    }
    ,
    Wenge(TreeBranchDefinition.MILLETTIA, "wenge", "laurentii", true, EnumLeafType.DECIDUOUS, new Color(11379031), new Color(11373143), EnumForestryWoodType.WENGE){

        @Override
        public Feature<NoFeatureConfig> getTreeFeature(ITreeGenData tree) {
            return new FeatureWenge(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            ((IAlleleTreeSpeciesBuilder)treeSpecies.addFruitFamily(EnumFruitFamily.JUNGLE).addFruitFamily(EnumFruitFamily.NUX).setRarity(5.0E-4f).setHumidity(EnumHumidity.DAMP)).setTemperature(EnumTemperature.WARM);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(TreeChromosomes.FERTILITY, EnumAllele.Saplings.LOWEST);
            template.set(TreeChromosomes.GIRTH, 2);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Cocobolo, Balsa, 10);
        }
    }
    ,
    Baobab(TreeBranchDefinition.ADANSONIA, "grandidierBaobab", "digitata", true, EnumLeafType.DECIDUOUS, new Color(0xFEFF8F), new Color(16767375), EnumForestryWoodType.BAOBAB){

        @Override
        public Feature<NoFeatureConfig> getTreeFeature(ITreeGenData tree) {
            return new FeatureBaobab(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            ((IAlleleTreeSpeciesBuilder)treeSpecies.addFruitFamily(EnumFruitFamily.JUNGLE).addFruitFamily(EnumFruitFamily.NUX).setRarity(0.005f).setTemperature(EnumTemperature.HOT)).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(TreeChromosomes.HEIGHT, EnumAllele.Height.LARGE);
            template.set(TreeChromosomes.SAPPINESS, EnumAllele.Sappiness.LOWER);
            template.set(TreeChromosomes.MATURATION, EnumAllele.Maturation.SLOW);
            template.set(TreeChromosomes.GIRTH, 3);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Balsa, Wenge, 10);
        }
    }
    ,
    Mahoe(TreeBranchDefinition.TALIPARITI, "blueMahoe", "elatum", true, EnumLeafType.DECIDUOUS, new Color(10533403), new Color(7971189), EnumForestryWoodType.MAHOE){

        @Override
        public Feature<NoFeatureConfig> getTreeFeature(ITreeGenData tree) {
            return new FeatureMahoe(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.JUNGLE).addFruitFamily(EnumFruitFamily.POMES).addFruitFamily(EnumFruitFamily.PRUNES).setRarity(5.0E-6f).setTemperature(EnumTemperature.WARM);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(TreeChromosomes.HEIGHT, EnumAllele.Height.SMALL);
            template.set(TreeChromosomes.SAPPINESS, EnumAllele.Sappiness.HIGH);
            template.set(TreeChromosomes.MATURATION, EnumAllele.Maturation.SLOWEST);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Balsa, Acacia, 5);
        }
    }
    ,
    Willow(TreeBranchDefinition.SALIX, "whiteWillow", "alba", true, EnumLeafType.WILLOW, new Color(10729637), new Color(10729552), EnumForestryWoodType.WILLOW){

        @Override
        public Feature<NoFeatureConfig> getTreeFeature(ITreeGenData tree) {
            return new FeatureWillow(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.NUX).addFruitFamily(EnumFruitFamily.PRUNES).addFruitFamily(EnumFruitFamily.POMES).setRarity(0.0025f).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(TreeChromosomes.HEIGHT, EnumAllele.Height.AVERAGE);
            template.set(TreeChromosomes.SAPPINESS, EnumAllele.Sappiness.LOW);
            template.set(TreeChromosomes.MATURATION, EnumAllele.Maturation.FASTER);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Oak, Birch, 10).restrictTemperature(EnumTemperature.WARM, EnumTemperature.HOT).restrictHumidity(EnumHumidity.DAMP);
            this.registerMutation(Oak, Lime, 10).restrictTemperature(EnumTemperature.WARM, EnumTemperature.HOT).restrictHumidity(EnumHumidity.DAMP);
            this.registerMutation(Lime, Birch, 10).restrictTemperature(EnumTemperature.WARM, EnumTemperature.HOT).restrictHumidity(EnumHumidity.DAMP);
        }
    }
    ,
    Sipiri(TreeBranchDefinition.CHLOROCARDIUM, "sipiri", "rodiei", true, EnumLeafType.DECIDUOUS, new Color(6785297), new Color(7971189), EnumForestryWoodType.GREENHEART){

        @Override
        public Feature<NoFeatureConfig> getTreeFeature(ITreeGenData tree) {
            return new FeatureGreenheart(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            ((IAlleleTreeSpeciesBuilder)treeSpecies.addFruitFamily(EnumFruitFamily.JUNGLE).setRarity(0.0025f).setTemperature(EnumTemperature.WARM)).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(TreeChromosomes.HEIGHT, EnumAllele.Height.LARGE);
            template.set(TreeChromosomes.SAPPINESS, EnumAllele.Sappiness.LOW);
            template.set(TreeChromosomes.MATURATION, EnumAllele.Maturation.SLOW);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Kapok, Mahogony, 10).restrictTemperature(EnumTemperature.WARM, EnumTemperature.HOT).restrictHumidity(EnumHumidity.DAMP);
        }
    }
    ,
    Papaya(TreeBranchDefinition.CARICA, "papaya", "papaya", true, EnumLeafType.PALM, new Color(7184216), new Color(7726709), EnumForestryWoodType.PAPAYA){

        @Override
        public Feature<NoFeatureConfig> getTreeFeature(ITreeGenData tree) {
            return new FeaturePapaya(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            ((IAlleleTreeSpeciesBuilder)treeSpecies.addFruitFamily(EnumFruitFamily.JUNGLE).addFruitFamily(EnumFruitFamily.NUX).setRarity(0.005f).setTemperature(EnumTemperature.WARM)).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(TreeChromosomes.FRUITS, AlleleFruits.fruitPapaya);
            template.set(TreeChromosomes.FERTILITY, EnumAllele.Saplings.LOW);
            template.set(TreeChromosomes.SAPPINESS, EnumAllele.Sappiness.LOWER);
            template.set(TreeChromosomes.HEIGHT, EnumAllele.Height.AVERAGE);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Jungle, Cherry, 5);
        }
    }
    ,
    Date(TreeBranchDefinition.PHOENIX, "datePalm", "dactylifera", true, EnumLeafType.PALM, new Color(13356409), new Color(11793264), EnumForestryWoodType.PALM){

        @Override
        public Feature<NoFeatureConfig> getTreeFeature(ITreeGenData tree) {
            return new FeatureDate(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            ((IAlleleTreeSpeciesBuilder)treeSpecies.addFruitFamily(EnumFruitFamily.JUNGLE).addFruitFamily(EnumFruitFamily.NUX).setRarity(0.005f).setTemperature(EnumTemperature.WARM)).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(TreeChromosomes.FRUITS, AlleleFruits.fruitDates);
            template.set(TreeChromosomes.FERTILITY, EnumAllele.Saplings.LOW);
            template.set(TreeChromosomes.YIELD, EnumAllele.Yield.LOW);
            template.set(TreeChromosomes.SAPPINESS, EnumAllele.Sappiness.LOW);
            template.set(TreeChromosomes.HEIGHT, EnumAllele.Height.AVERAGE);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Jungle, Papaya, 5);
        }
    }
    ,
    Poplar(TreeBranchDefinition.POPULUS, "whitePoplar", "alba", true, EnumLeafType.DECIDUOUS, new Color(10729637), new Color(5479698), EnumForestryWoodType.POPLAR){

        @Override
        public Feature<NoFeatureConfig> getTreeFeature(ITreeGenData tree) {
            return new FeaturePoplar(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.PRUNES).addFruitFamily(EnumFruitFamily.POMES);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(TreeChromosomes.HEIGHT, EnumAllele.Height.SMALL);
            template.set(TreeChromosomes.SAPPINESS, EnumAllele.Sappiness.LOW);
            template.set(TreeChromosomes.MATURATION, EnumAllele.Maturation.SLOWER);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Birch, Willow, 5);
            this.registerMutation(Oak, Willow, 5);
            this.registerMutation(Lime, Willow, 5);
        }
    };

    public static final TreeDefinition[] VALUES;
    private final TreeBranchDefinition branch;
    private final IAlleleTreeSpecies species;
    private final IWoodType woodType;
    @Nullable
    private IAlleleTemplate template;
    @Nullable
    private IGenome genome;

    private TreeDefinition(TreeBranchDefinition branch, String speciesName, String binomial, boolean dominant, EnumLeafType leafType, Color primary, Color secondary, IWoodType woodType) {
        String uid = "tree_" + this.func_176610_l();
        String unlocalizedDescription = "for.description.tree" + this;
        String unlocalizedName = "for.trees.species." + speciesName;
        this.branch = branch;
        ILeafSpriteProvider leafIconProvider = TreeManager.treeFactory.getLeafIconProvider(leafType, primary, secondary);
        IGermlingModelProvider germlingIconProvider = ModelProviderFactory.create(woodType, uid, leafIconProvider);
        IAlleleTreeSpeciesBuilder speciesBuilder = ((IAlleleTreeSpeciesBuilder)((IAlleleTreeSpeciesBuilder)((IAlleleTreeSpeciesBuilder)((IAlleleTreeSpeciesBuilder)((IAlleleTreeSpeciesBuilder)TreeManager.treeFactory.createSpecies("forestry", uid, speciesName).setDescriptionKey(unlocalizedDescription)).setTranslationKey(unlocalizedName)).setDominant(dominant)).setBranch(branch.getBranch())).setBinomial(binomial)).setLeafSprite(leafIconProvider).setModel(germlingIconProvider).setLeaf(value -> new LeafProvider(this)).setGenerator(this);
        this.setSpeciesProperties(speciesBuilder);
        this.species = speciesBuilder.build();
        this.woodType = woodType;
    }

    protected abstract void setSpeciesProperties(IAlleleTreeSpeciesBuilder var1);

    protected abstract void setAlleles(IAlleleTemplateBuilder var1);

    protected abstract void registerMutations();

    public boolean hasFruitLeaves() {
        return false;
    }

    @Override
    public boolean setLogBlock(IGenome genome, IWorld world, BlockPos pos, Direction facing) {
        boolean fireproof = genome.getActiveValue(TreeChromosomes.FIREPROOF);
        BlockState logBlock = TreeManager.woodAccess.getBlock(this.woodType, WoodBlockKind.LOG, fireproof);
        Direction.Axis axis = facing.func_176740_k();
        return world.func_180501_a(pos, (BlockState)logBlock.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)axis), 19);
    }

    @Override
    public boolean setLeaves(IGenome genome, IWorld world, @Nullable GameProfile owner, BlockPos pos, Random rand) {
        if (owner == null && new TemplateMatcher(genome).matches()) {
            IFruitProvider fruitProvider = genome.getActiveAllele(TreeChromosomes.FRUITS).getProvider();
            FeatureBlockGroup<BlockAbstractLeaves, TreeDefinition> leavesGroup = fruitProvider.isFruitLeaf(genome, world, pos) && rand.nextFloat() <= fruitProvider.getFruitChance(genome, world, pos) ? ArboricultureBlocks.LEAVES_DEFAULT_FRUIT : ArboricultureBlocks.LEAVES_DEFAULT;
            BlockState defaultLeaves = ((FeatureBlock)leavesGroup.get(this)).defaultState();
            return world.func_180501_a(pos, defaultLeaves, 19);
        }
        BlockState leaves = ArboricultureBlocks.LEAVES.defaultState();
        boolean placed = world.func_180501_a(pos, LeavesBlock.func_208493_b((BlockState)leaves, (IWorld)world, (BlockPos)pos), 19);
        if (!placed) {
            return false;
        }
        TileLeaves tileLeaves = TileUtil.getTile((IBlockReader)world, pos, TileLeaves.class);
        if (tileLeaves == null) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 19);
            return false;
        }
        if (owner != null) {
            tileLeaves.getOwnerHandler().setOwner(owner);
        }
        tileLeaves.setTree(new Tree(genome));
        return true;
    }

    public static void initTrees() {
        for (TreeDefinition tree : TreeDefinition.values()) {
            tree.registerMutations();
        }
    }

    @Override
    public void registerAlleles(IAlleleRegistry registry) {
        registry.registerAllele(this.species, TreeChromosomes.SPECIES);
    }

    @Override
    public <C extends IRootComponent<ITree>> void onComponentSetup(C component) {
        ComponentKey key = component.getKey();
        if (key == ComponentKeys.TEMPLATES) {
            ITemplateContainer registry = (ITemplateContainer)component;
            IAlleleTemplateBuilder templateBuilder = this.branch.getTemplateBuilder();
            templateBuilder.set(TreeChromosomes.SPECIES, this.species);
            this.setAlleles(templateBuilder);
            this.template = templateBuilder.build();
            this.genome = this.template.toGenome();
            registry.registerTemplate(this.template);
        }
    }

    protected final ITreeMutationBuilder registerMutation(TreeDefinition parent1, TreeDefinition parent2, int chance) {
        return TreeManager.treeMutationFactory.createMutation(parent1.species, parent2.species, this.getTemplate().alleles(), chance);
    }

    @Override
    public final IAlleleTemplate getTemplate() {
        return this.template;
    }

    @Override
    public final IGenome getGenome() {
        return this.genome;
    }

    @Override
    public IAlleleTreeSpecies getSpecies() {
        return this.species;
    }

    public final String getUID() {
        return this.species.getRegistryName().toString();
    }

    public final String getUnlocalizedName() {
        return this.species.getLocalisationKey();
    }

    @Override
    public final ITree createIndividual() {
        return new Tree(this.genome);
    }

    @Override
    public final ItemStack getMemberStack(EnumGermlingType treeType) {
        ITree tree = this.createIndividual();
        return TreeManager.treeRoot.getTypes().createStack(tree, treeType);
    }

    public String func_176610_l() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    static {
        VALUES = TreeDefinition.values();
    }
}

