/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.charcoal.jei;

import forestry.api.arboriculture.ICharcoalManager;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.ForestryAPI;
import forestry.arboriculture.charcoal.jei.CharcoalPileWallCategory;
import forestry.arboriculture.charcoal.jei.CharcoalPileWallWrapper;
import forestry.arboriculture.features.CharcoalBlocks;
import java.util.Collection;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class CharcoalJeiPlugin
implements IModPlugin {
    public static final ResourceLocation RECIPE_UID = new ResourceLocation("forestry:charcoal.pile");

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("forestry", "charcoal");
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        if (!ForestryAPI.enabledModules.contains(new ResourceLocation("forestry", "charcoal"))) {
            return;
        }
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new CharcoalPileWallCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ICharcoalManager charcoalManager = TreeManager.charcoalManager;
        if (!ForestryAPI.enabledModules.contains(new ResourceLocation("forestry", "charcoal")) || charcoalManager == null) {
            return;
        }
        registration.addRecipes((Collection)charcoalManager.getWalls().stream().map(CharcoalPileWallWrapper::new).collect(Collectors.toList()), RECIPE_UID);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        if (!ForestryAPI.enabledModules.contains(new ResourceLocation("forestry", "charcoal"))) {
            return;
        }
        registration.addRecipeCatalyst((Object)CharcoalBlocks.WOOD_PILE.stack(), new ResourceLocation[]{RECIPE_UID});
    }
}

