/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.charcoal;

import com.google.common.base.Preconditions;
import forestry.api.arboriculture.ICharcoalManager;
import forestry.api.arboriculture.ICharcoalPileWall;
import forestry.arboriculture.charcoal.CharcoalPileWall;
import forestry.core.config.Config;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;

public class CharcoalManager
implements ICharcoalManager {
    private final List<ICharcoalPileWall> walls = new ArrayList<ICharcoalPileWall>();

    @Override
    public void registerWall(Block block, int amount) {
        Preconditions.checkNotNull((Object)block, (Object)"block must not be null.");
        Preconditions.checkArgument((amount > -Config.charcoalAmountBase && amount < 63 - Config.charcoalAmountBase ? 1 : 0) != 0, (Object)"amount must be bigger than -10 and smaller than 64.");
        this.walls.add(new CharcoalPileWall(block, amount));
    }

    @Override
    public void registerWall(BlockState blockState, int amount) {
        Preconditions.checkNotNull((Object)blockState, (Object)"block state must not be null.");
        Preconditions.checkArgument((amount > -Config.charcoalAmountBase && amount < 63 - Config.charcoalAmountBase ? 1 : 0) != 0, (Object)"amount must be bigger than -10 and smaller than 64.");
        this.walls.add(new CharcoalPileWall(blockState, amount));
    }

    @Override
    public void registerWall(ICharcoalPileWall wall) {
        this.walls.add(wall);
    }

    @Override
    @Nullable
    public ICharcoalPileWall getWall(BlockState state) {
        for (ICharcoalPileWall wall : this.walls) {
            if (!wall.matches(state)) continue;
            return wall;
        }
        return null;
    }

    @Override
    public boolean removeWall(Block block) {
        return this.removeWall(block.func_176223_P());
    }

    @Override
    public boolean removeWall(BlockState state) {
        for (ICharcoalPileWall wall : this.walls) {
            if (!wall.matches(state)) continue;
            return this.walls.remove(wall);
        }
        return false;
    }

    @Override
    public Collection<ICharcoalPileWall> getWalls() {
        return this.walls;
    }
}

