/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import com.google.common.base.Preconditions;
import forestry.api.arboriculture.ICharcoalManager;
import forestry.api.arboriculture.ICharcoalPileWall;
import forestry.api.arboriculture.TreeManager;
import forestry.arboriculture.blocks.BlockAsh;
import forestry.arboriculture.features.CharcoalBlocks;
import forestry.core.config.Config;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class BlockWoodPile
extends Block {
    public static final BooleanProperty IS_ACTIVE = BooleanProperty.func_177716_a((String)"active");
    public static final IntegerProperty AGE = BlockStateProperties.field_208170_W;
    public static final int RANDOM_TICK = 160;
    public static final int TICK_RATE = 960;

    public BlockWoodPile() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(1.5f).func_200947_a(SoundType.field_185848_a).harvestLevel(0).harvestTool(ToolType.AXE).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0))).func_206870_a((Property)IS_ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{IS_ACTIVE, AGE});
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState p_220082_4_, boolean p_220082_5_) {
        if (!((Boolean)state.func_177229_b((Property)IS_ACTIVE)).booleanValue()) {
            for (Direction facing : Direction.field_199792_n) {
                BlockState facingState = world.func_180495_p(pos.func_177972_a(facing));
                if (facingState.func_177230_c() != this || !((Boolean)facingState.func_177229_b((Property)IS_ACTIVE)).booleanValue()) continue;
                world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)IS_ACTIVE, (Comparable)Boolean.valueOf(true)));
                break;
            }
        }
        world.func_205220_G_().func_205360_a(pos, (Object)this, 960 + world.field_73012_v.nextInt(160));
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean p_220069_6_) {
        boolean isActive = (Boolean)state.func_177229_b((Property)IS_ACTIVE);
        BlockState neighborState = world.func_180495_p(fromPos);
        if (!(neighborState.func_177230_c() != Blocks.field_150480_ab && neighborState.func_177230_c() != this || isActive)) {
            this.activatePile(state, world, pos, true);
        }
    }

    private void activatePile(BlockState state, World world, BlockPos pos, boolean scheduleUpdate) {
        world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)IS_ACTIVE, (Comparable)Boolean.valueOf(true)), 2);
        if (scheduleUpdate) {
            world.func_205220_G_().func_205360_a(pos, (Object)this, (960 + world.field_73012_v.nextInt(160)) / 4);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((Property)IS_ACTIVE)).booleanValue()) {
            for (Direction facing : Direction.field_199792_n) {
                BlockPos position = pos.func_177972_a(facing);
                if (!world.func_175667_e(position)) continue;
                BlockState blockState = world.func_180495_p(position);
                Block block = blockState.func_177230_c();
                if (block == this) {
                    if (!((Boolean)state.func_177229_b((Property)IS_ACTIVE)).booleanValue() && ((Boolean)blockState.func_177229_b((Property)IS_ACTIVE)).booleanValue()) {
                        this.activatePile(state, (World)world, pos, false);
                        continue;
                    }
                    if (((Boolean)blockState.func_177229_b((Property)IS_ACTIVE)).booleanValue() || !((Boolean)state.func_177229_b((Property)IS_ACTIVE)).booleanValue()) continue;
                    this.activatePile(blockState, (World)world, position, true);
                    continue;
                }
                if (!world.func_175623_d(position) && Block.func_220055_a((IWorldReader)world, (BlockPos)position, (Direction)facing.func_176734_d()) && !block.isFlammable(blockState, (IBlockReader)world, position, facing.func_176734_d())) continue;
                world.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
                return;
            }
            if (rand.nextFloat() < 0.5f) {
                if ((Integer)state.func_177229_b((Property)AGE) < 7) {
                    world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf((Integer)state.func_177229_b((Property)AGE) + 1)), 2);
                } else {
                    BlockState ashState = CharcoalBlocks.ASH.with(BlockAsh.AMOUNT, Math.min(Math.round((float)Config.charcoalAmountBase + this.getCharcoalAmount((World)world, pos)), 63));
                    world.func_180501_a(pos, ashState, 2);
                }
            }
            world.func_205220_G_().func_205360_a(pos, (Object)this, 960 + world.field_73012_v.nextInt(160));
        }
    }

    public int getFireSpreadSpeed(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return 12;
    }

    public boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return true;
    }

    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return 25;
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        if (((Boolean)state.func_177229_b((Property)IS_ACTIVE)).booleanValue()) {
            return 10;
        }
        return super.getLightValue(state, world, pos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        if ((float)rand.nextInt() < 0.25f) {
            return;
        }
        if (((Boolean)state.func_177229_b((Property)IS_ACTIVE)).booleanValue()) {
            if (rand.nextDouble() < 0.05) {
                world.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
            }
            float f = (float)pos.func_177958_n() + 0.5f;
            float f1 = (float)pos.func_177956_o() + 0.0f + rand.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)pos.func_177952_p() + 0.5f;
            float f3 = 0.52f;
            float f4 = rand.nextFloat() * 0.6f - 0.3f;
            if (rand.nextDouble() < 0.2) {
                world.func_195594_a((IParticleData)ParticleTypes.field_197594_E, (double)(f + f3) - 0.5, (double)(f1 + 1.0f), (double)(f2 + f4), 0.0, 0.15, 0.0);
            } else {
                world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)(f + f3) - 0.5, (double)(f1 + 1.0f), (double)(f2 + f4), 0.0, 0.15, 0.0);
            }
        }
    }

    private float getCharcoalAmount(World world, BlockPos pos) {
        float charcoalAmount = 0.0f;
        for (Direction facing : Direction.field_199792_n) {
            charcoalAmount += (float)this.getCharcoalFaceAmount(world, pos, facing);
        }
        return MathHelper.func_76131_a((float)(charcoalAmount / 6.0f), (float)0.0f, (float)(63.0f - (float)Config.charcoalAmountBase));
    }

    private int getCharcoalFaceAmount(World world, BlockPos pos, Direction facing) {
        ICharcoalManager charcoalManager = (ICharcoalManager)Preconditions.checkNotNull((Object)TreeManager.charcoalManager);
        Collection<ICharcoalPileWall> walls = charcoalManager.getWalls();
        BlockPos.Mutable testPos = new BlockPos.Mutable();
        testPos.func_189533_g((Vector3i)pos).func_189536_c(facing);
        for (int i = 0; i < Config.charcoalWallCheckRange && world.func_175667_e((BlockPos)testPos) && !world.func_175623_d((BlockPos)testPos); ++i) {
            BlockState state = world.func_180495_p((BlockPos)testPos);
            ICharcoalPileWall wall = charcoalManager.getWall(state);
            if (wall != null) {
                return wall.getCharcoalAmount();
            }
            testPos.func_189536_c(facing);
        }
        return 0;
    }
}

