/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import forestry.api.arboriculture.EnumForestryWoodType;
import forestry.api.arboriculture.EnumVanillaWoodType;
import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.arboriculture.IWoodTyped;
import forestry.core.utils.Translator;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class WoodHelper {
    public static ITextComponent getDisplayName(IWoodTyped wood, IWoodType woodType) {
        ITextComponent displayName;
        WoodBlockKind blockKind = wood.getBlockKind();
        if (woodType instanceof EnumForestryWoodType) {
            String customUnlocalizedName = "block.forestry." + (Object)((Object)blockKind) + "." + woodType;
            displayName = Translator.canTranslateToLocal(customUnlocalizedName) ? new TranslationTextComponent(customUnlocalizedName) : new TranslationTextComponent("for." + (Object)((Object)blockKind) + ".grammar", new Object[]{new TranslationTextComponent("for.trees.woodType." + woodType)});
        } else if (woodType instanceof EnumVanillaWoodType) {
            displayName = TreeManager.woodAccess.getStack(woodType, blockKind, false).func_200301_q();
        } else {
            throw new IllegalArgumentException("Unknown wood type: " + woodType);
        }
        if (wood.isFireproof()) {
            displayName = new TranslationTextComponent("block.forestry.fireproof", new Object[]{displayName});
        }
        return displayName;
    }
}

