/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.tiles;

import com.google.common.base.Predicate;
import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.apiculture.genetics.IBee;
import forestry.api.apiculture.hives.IHiveRegistry;
import forestry.api.apiculture.hives.IHiveTile;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.apiculture.ModuleApiculture;
import forestry.apiculture.WorldgenBeekeepingLogic;
import forestry.apiculture.blocks.BlockBeeHive;
import forestry.apiculture.features.ApicultureTiles;
import forestry.apiculture.genetics.BeeDefinition;
import forestry.apiculture.genetics.alleles.AlleleEffect;
import forestry.apiculture.tiles.HiveBeeHousingInventory;
import forestry.core.config.Config;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.network.packets.PacketActiveUpdate;
import forestry.core.tiles.IActivatable;
import forestry.core.utils.DamageSourceForestry;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.TickHelper;
import genetics.api.GeneticHelper;
import genetics.api.individual.IGenome;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileHive
extends TileEntity
implements ITickableTileEntity,
IHiveTile,
IActivatable,
IBeeHousing {
    private static final DamageSource damageSourceBeeHive = new DamageSourceForestry("bee.hive");
    private final InventoryAdapter contained = new InventoryAdapter(2, "Contained");
    private final HiveBeeHousingInventory inventory;
    private final WorldgenBeekeepingLogic beeLogic;
    private final IErrorLogic errorLogic;
    private final Predicate<LivingEntity> beeTargetPredicate;
    private final TickHelper tickHelper = new TickHelper();
    @Nullable
    private IBee containedBee = null;
    private boolean active = false;
    private boolean angry = false;
    private int calmTime;

    public TileHive() {
        super(ApicultureTiles.HIVE.tileType());
        this.inventory = new HiveBeeHousingInventory(this);
        this.beeLogic = new WorldgenBeekeepingLogic(this);
        this.errorLogic = ForestryAPI.errorStateRegistry.createErrorLogic();
        this.beeTargetPredicate = new BeeTargetPredicate(this);
    }

    public void func_73660_a() {
        if (Config.generateBeehivesDebug) {
            return;
        }
        this.tickHelper.onTick();
        if (this.field_145850_b.field_72995_K) {
            if (this.active && this.tickHelper.updateOnInterval(4) && this.beeLogic.canDoBeeFX()) {
                this.beeLogic.doBeeFX();
            }
        } else {
            boolean canWork = this.beeLogic.canWork();
            if (this.tickHelper.updateOnInterval(this.angry ? 10 : 200)) {
                if (this.calmTime == 0) {
                    if (canWork) {
                        AxisAlignedBB boundingBox;
                        List entities;
                        if (this.angry && ModuleApiculture.hiveDamageOnAttack && (this.field_145850_b.func_72912_H().func_176130_y() != Difficulty.PEACEFUL || ModuleApiculture.hivesDamageOnPeaceful) && !(entities = this.field_145850_b.func_175647_a(LivingEntity.class, boundingBox = AlleleEffect.getBounding(this.getContainedBee().getGenome(), this), this.beeTargetPredicate)).isEmpty()) {
                            Collections.shuffle(entities);
                            LivingEntity entity = (LivingEntity)entities.get(0);
                            if (!(!(entity instanceof PlayerEntity) && ModuleApiculture.hivesDamageOnlyPlayers || entity.func_70090_H() && !ModuleApiculture.hivesDamageUnderwater)) {
                                TileHive.attack(entity, 2);
                            }
                        }
                        this.beeLogic.doWork();
                    }
                } else {
                    --this.calmTime;
                }
            }
            this.setActive(this.calmTime == 0);
        }
    }

    public IBee getContainedBee() {
        if (this.containedBee == null) {
            Optional optionalBee;
            IGenome beeGenome = null;
            ItemStack containedBee = this.contained.func_70301_a(0);
            if (!containedBee.func_190926_b() && (optionalBee = BeeManager.beeRoot.create(containedBee)).isPresent()) {
                IBee bee = (IBee)optionalBee.get();
                beeGenome = bee.getGenome();
            }
            if (beeGenome == null) {
                beeGenome = this.getGenomeFromBlock();
            }
            if (beeGenome == null) {
                beeGenome = BeeDefinition.FOREST.getGenome();
            }
            this.containedBee = (IBee)BeeManager.beeRoot.create(beeGenome);
        }
        return this.containedBee;
    }

    @Nullable
    private IGenome getGenomeFromBlock() {
        BlockState blockState;
        Block block;
        if (this.field_145850_b.func_175667_e(this.field_174879_c) && (block = (blockState = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c()) instanceof BlockBeeHive) {
            IHiveRegistry.HiveType hiveType = ((BlockBeeHive)block).getType();
            String speciesUid = hiveType.getSpeciesUid();
            return GeneticHelper.genomeFromTemplate(speciesUid, BeeManager.beeRootDefinition);
        }
        return null;
    }

    public void setContained(List<ItemStack> bees) {
        for (ItemStack itemstack : bees) {
            InventoryUtil.addStack((IInventory)this.contained, itemstack, true);
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT compoundNBT) {
        super.func_230337_a_(state, compoundNBT);
        this.contained.read(compoundNBT);
        this.beeLogic.read(compoundNBT);
    }

    public CompoundNBT func_189515_b(CompoundNBT compoundNBT) {
        compoundNBT = super.func_189515_b(compoundNBT);
        this.contained.write(compoundNBT);
        this.beeLogic.write(compoundNBT);
        return compoundNBT;
    }

    @Override
    public void calmBees() {
        this.calmTime = 5;
        this.angry = false;
        this.setActive(false);
    }

    @Override
    public boolean isAngry() {
        return this.angry;
    }

    @Override
    public void onAttack(World world, BlockPos pos, PlayerEntity player) {
        if (this.calmTime == 0) {
            this.angry = true;
        }
    }

    @Override
    public void onBroken(World world, BlockPos pos, PlayerEntity player, boolean canHarvest) {
        if (this.calmTime == 0) {
            TileHive.attack((LivingEntity)player, 10);
        }
        if (canHarvest) {
            for (ItemStack beeStack : InventoryUtil.getStacks((IInventory)this.contained)) {
                if (beeStack == null) continue;
                ItemStackUtil.dropItemStackAsEntity(beeStack, world, pos);
            }
        }
    }

    private static void attack(LivingEntity entity, int maxDamage) {
        double attackAmount = entity.field_70170_p.field_73012_v.nextDouble() / 2.0 + 0.5;
        int damage = (int)(attackAmount * (double)maxDamage);
        if (damage > 0) {
            int count = BeeManager.armorApiaristHelper.wearsItems(entity, new ResourceLocation(TileHive.damageSourceBeeHive.field_76373_n), true);
            if (entity.field_70170_p.field_73012_v.nextInt(4) >= count) {
                entity.func_70097_a(damageSourceBeeHive, (float)damage);
            }
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (!this.field_145850_b.field_72995_K) {
            NetworkUtil.sendNetworkPacket(new PacketActiveUpdate(this), this.field_174879_c, this.field_145850_b);
        }
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        nbt.func_74757_a("active", this.calmTime == 0);
        this.beeLogic.write(nbt);
        return nbt;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        this.setActive(tag.func_74767_n("active"));
        this.beeLogic.read(tag);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        CompoundNBT nbt = pkt.func_148857_g();
        this.handleUpdateTag(this.func_195044_w(), nbt);
    }

    @Override
    public Iterable<IBeeModifier> getBeeModifiers() {
        return Collections.emptyList();
    }

    @Override
    public Iterable<IBeeListener> getBeeListeners() {
        return Collections.emptyList();
    }

    @Override
    public IBeeHousingInventory getBeeInventory() {
        return this.inventory;
    }

    @Override
    public IBeekeepingLogic getBeekeepingLogic() {
        return this.beeLogic;
    }

    @Override
    public EnumTemperature getTemperature() {
        return EnumTemperature.getFromBiome(this.getBiome(), this.func_174877_v());
    }

    @Override
    public EnumHumidity getHumidity() {
        float humidity = this.getBiome().func_76727_i();
        return EnumHumidity.getFromValue(humidity);
    }

    @Override
    public int getBlockLightValue() {
        return this.func_145831_w().func_72935_r() ? 15 : 0;
    }

    @Override
    public boolean canBlockSeeTheSky() {
        return true;
    }

    @Override
    public boolean isRaining() {
        return this.field_145850_b.func_175727_C(this.func_174877_v().func_177984_a());
    }

    @Override
    public World getWorldObj() {
        return this.field_145850_b;
    }

    @Override
    public Biome getBiome() {
        return this.func_145831_w().func_226691_t_(this.func_174877_v());
    }

    @Override
    @Nullable
    public GameProfile getOwner() {
        return null;
    }

    @Override
    public Vector3d getBeeFXCoordinates() {
        BlockPos pos = this.func_174877_v();
        return new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.25, (double)pos.func_177952_p() + 0.5);
    }

    @Override
    public IErrorLogic getErrorLogic() {
        return this.errorLogic;
    }

    @Override
    public BlockPos getCoordinates() {
        return this.func_174877_v();
    }

    private static class BeeTargetPredicate
    implements Predicate<LivingEntity> {
        private final IHiveTile hive;

        public BeeTargetPredicate(IHiveTile hive) {
            this.hive = hive;
        }

        public boolean apply(@Nullable LivingEntity input) {
            if (input != null && input.func_70089_S() && !input.func_82150_aj()) {
                if (input instanceof PlayerEntity) {
                    return EntityPredicates.field_188444_d.test(input);
                }
                if (this.hive.isAngry()) {
                    return true;
                }
                if (input instanceof IMob) {
                    return !(input instanceof EndermanEntity) && !(input instanceof ZombifiedPiglinEntity);
                }
            }
            return false;
        }
    }
}

