/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import forestry.apiculture.particles.ApicultureParticles;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;

public class BeeTargetParticleData
implements IParticleData {
    public static final IParticleData.IDeserializer<BeeTargetParticleData> DESERIALIZER = new IParticleData.IDeserializer<BeeTargetParticleData>(){

        @Nonnull
        public BeeTargetParticleData fromCommand(@Nonnull ParticleType<BeeTargetParticleData> type, @Nonnull StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            int entityId = reader.readInt();
            reader.expect(' ');
            int color = reader.readInt();
            return new BeeTargetParticleData(entityId, color);
        }

        public BeeTargetParticleData fromNetwork(@Nonnull ParticleType<BeeTargetParticleData> type, PacketBuffer buf) {
            return new BeeTargetParticleData(buf.readInt(), buf.readInt());
        }
    };
    public static Codec<BeeTargetParticleData> CODEC = RecordCodecBuilder.create(val -> val.group((App)Codec.INT.fieldOf("entity").forGetter(data -> data.entity), (App)Codec.INT.fieldOf("color").forGetter(data -> data.color)).apply((Applicative)val, BeeTargetParticleData::new));
    public final int entity;
    public final int color;

    public BeeTargetParticleData(int entity, int color) {
        this.entity = entity;
        this.color = color;
    }

    public BeeTargetParticleData(Entity entity, int color) {
        this.entity = entity.func_145782_y();
        this.color = color;
    }

    @Nonnull
    public ParticleType<?> func_197554_b() {
        return ApicultureParticles.BEE_TARGET_ENTITY_PARTICLE.getParticleType();
    }

    public void func_197553_a(@Nonnull PacketBuffer buffer) {
        buffer.writeLong((long)this.entity);
        buffer.writeInt(this.color);
    }

    @Nonnull
    public String func_197555_a() {
        return String.format(Locale.ROOT, "%s %d %d", this.func_197554_b().getRegistryName(), this.entity, this.color);
    }
}

