/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import forestry.core.registration.ParticleTypeRegistryObject;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.BlockPos;

public class BeeParticleData
implements IParticleData {
    public static final IParticleData.IDeserializer<BeeParticleData> DESERIALIZER = new IParticleData.IDeserializer<BeeParticleData>(){

        @Nonnull
        public BeeParticleData fromCommand(@Nonnull ParticleType<BeeParticleData> type, @Nonnull StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            long direction = reader.readLong();
            reader.expect(' ');
            int color = reader.readInt();
            return new BeeParticleData(type, direction, color);
        }

        public BeeParticleData fromNetwork(@Nonnull ParticleType<BeeParticleData> type, PacketBuffer buf) {
            return new BeeParticleData(type, buf.readLong(), buf.readInt());
        }
    };
    public final ParticleType<BeeParticleData> type;
    public final BlockPos destination;
    public final int color;

    public static Codec<BeeParticleData> createCodec(ParticleType<BeeParticleData> type) {
        return RecordCodecBuilder.create(val -> val.group((App)Codec.LONG.fieldOf("direction").forGetter(data -> data.destination.func_218275_a()), (App)Codec.INT.fieldOf("color").forGetter(data -> data.color)).apply((Applicative)val, (destination1, color1) -> new BeeParticleData(type, (long)destination1, (int)color1)));
    }

    public BeeParticleData(ParticleType<BeeParticleData> type, long destination, int color) {
        this.type = type;
        this.destination = BlockPos.func_218283_e((long)destination);
        this.color = color;
    }

    public BeeParticleData(ParticleTypeRegistryObject<BeeParticleData> type, BlockPos destination, int color) {
        this.type = type.getParticleType();
        this.destination = destination;
        this.color = color;
    }

    @Nonnull
    public ParticleType<?> func_197554_b() {
        return this.type;
    }

    public void func_197553_a(@Nonnull PacketBuffer buffer) {
        buffer.writeRegistryId(this.type);
        buffer.writeLong(this.destination.func_218275_a());
        buffer.writeInt(this.color);
    }

    @Nonnull
    public String func_197555_a() {
        return String.format(Locale.ROOT, "%s %d %d %d %d", this.func_197554_b().getRegistryName(), this.destination.func_177958_n(), this.destination.func_177956_o(), this.destination.func_177952_p(), this.color);
    }
}

