/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.multiblock;

import forestry.api.climate.IClimateControlled;
import forestry.api.multiblock.IAlvearyComponent;
import forestry.apiculture.blocks.BlockAlvearyType;
import forestry.apiculture.multiblock.TileAlveary;
import forestry.core.network.packets.PacketActiveUpdate;
import forestry.core.tiles.IActivatable;
import forestry.core.utils.NetworkUtil;
import forestry.energy.EnergyHelper;
import forestry.energy.EnergyManager;
import forestry.energy.EnergyTransferMode;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public abstract class TileAlvearyClimatiser
extends TileAlveary
implements IActivatable,
IAlvearyComponent.Climatiser {
    private static final int WORK_CYCLES = 1;
    private static final int ENERGY_PER_OPERATION = 50;
    private final EnergyManager energyManager;
    private final IClimitiserDefinition definition;
    private int workingTime = 0;
    private boolean active;

    protected TileAlvearyClimatiser(BlockAlvearyType alvearyType, IClimitiserDefinition definition) {
        super(alvearyType);
        this.definition = definition;
        this.energyManager = new EnergyManager(1000, 2000);
        this.energyManager.setExternalMode(EnergyTransferMode.RECEIVE);
    }

    @Override
    public void changeClimate(int tick, IClimateControlled climateControlled) {
        if (this.workingTime < 20 && EnergyHelper.consumeEnergyToDoWork(this.energyManager, 1, 50)) {
            this.workingTime += 5;
        }
        if (this.workingTime > 0) {
            --this.workingTime;
            climateControlled.addTemperatureChange(this.definition.getChangePerTransfer(), this.definition.getBoundaryDown(), this.definition.getBoundaryUp());
        }
        this.setActive(this.workingTime > 0);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compoundNBT) {
        super.func_230337_a_(state, compoundNBT);
        this.energyManager.read(compoundNBT);
        this.workingTime = compoundNBT.func_74762_e("Heating");
        this.setActive(this.workingTime > 0);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compoundNBT) {
        compoundNBT = super.func_189515_b(compoundNBT);
        this.energyManager.write(compoundNBT);
        compoundNBT.func_74768_a("Heating", this.workingTime);
        return compoundNBT;
    }

    @Override
    protected void encodeDescriptionPacket(CompoundNBT packetData) {
        super.encodeDescriptionPacket(packetData);
        packetData.func_74757_a("Active", this.active);
    }

    @Override
    protected void decodeDescriptionPacket(CompoundNBT packetData) {
        super.decodeDescriptionPacket(packetData);
        this.setActive(packetData.func_74767_n("Active"));
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (this.field_145850_b != null) {
            if (this.field_145850_b.field_72995_K) {
                BlockPos pos = this.func_174877_v();
                Minecraft.func_71410_x().field_71438_f.func_215328_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            } else {
                NetworkUtil.sendNetworkPacket(new PacketActiveUpdate(this), this.field_174879_c, this.field_145850_b);
            }
        }
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        LazyOptional<T> energyCapability = this.energyManager.getCapability(capability);
        if (energyCapability.isPresent()) {
            return energyCapability;
        }
        return super.getCapability(capability, facing);
    }

    protected static interface IClimitiserDefinition {
        public float getChangePerTransfer();

        public float getBoundaryUp();

        public float getBoundaryDown();
    }
}

