/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import forestry.api.apiculture.ApicultureCapabilities;
import forestry.api.apiculture.hives.IHiveTile;
import forestry.api.core.ItemGroups;
import forestry.core.items.ItemForestry;
import forestry.core.render.ParticleRender;
import forestry.core.tiles.TileUtil;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class ItemSmoker
extends ItemForestry {
    public ItemSmoker() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroups.tabApiculture));
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (worldIn.field_72995_K && isSelected && worldIn.field_73012_v.nextInt(40) == 0) {
            ItemSmoker.addSmoke(stack, worldIn, entityIn, 1);
        }
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        super.onUsingTick(stack, player, count);
        World world = player.field_70170_p;
        ItemSmoker.addSmoke(stack, world, (Entity)player, count % 5 + 1);
    }

    private static HandSide getHandSide(ItemStack stack, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity LivingEntity2 = (LivingEntity)entity;
            Hand activeHand = LivingEntity2.func_184600_cs();
            HandSide handSide = LivingEntity2.func_184591_cq();
            if (activeHand == Hand.OFF_HAND) {
                handSide = handSide == HandSide.LEFT ? HandSide.RIGHT : HandSide.LEFT;
            }
            return handSide;
        }
        return HandSide.RIGHT;
    }

    private static void addSmoke(ItemStack stack, World world, Entity entity, int distance) {
        if (distance <= 0) {
            return;
        }
        Vector3d look = entity.func_70040_Z();
        HandSide handSide = ItemSmoker.getHandSide(stack, entity);
        Vector3d handOffset = handSide == HandSide.RIGHT ? look.func_72431_c(new Vector3d(0.0, 1.0, 0.0)) : look.func_72431_c(new Vector3d(0.0, -1.0, 0.0));
        Vector3d lookDistance = new Vector3d(look.field_72450_a * (double)distance, look.field_72448_b * (double)distance, look.field_72449_c * (double)distance);
        Vector3d scaledOffset = handOffset.func_186678_a(1.0 / (double)distance);
        Vector3d smokePos = lookDistance.func_178787_e(entity.func_213303_ch()).func_178787_e(scaledOffset);
        if (world.field_72995_K) {
            ParticleRender.addEntitySmokeFX(world, smokePos.field_72450_a, smokePos.field_72448_b + 1.0, smokePos.field_72449_c);
        }
        BlockPos blockPos = new BlockPos(smokePos.field_72450_a, smokePos.field_72448_b + 1.0, smokePos.field_72449_c);
        TileUtil.actOnTile((IWorldReader)world, blockPos, IHiveTile.class, IHiveTile::calmBees);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        playerIn.func_184598_c(handIn);
        ItemStack itemStack = playerIn.func_184586_b(handIn);
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemStack);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        TileUtil.actOnTile((IWorldReader)context.func_195991_k(), context.func_195995_a(), IHiveTile.class, IHiveTile::calmBees);
        return super.onItemUseFirst(stack, context);
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new ICapabilityProvider(){

            public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
                if (capability == ApicultureCapabilities.ARMOR_APIARIST) {
                    return LazyOptional.of(() -> capability.getDefaultInstance());
                }
                return LazyOptional.empty();
            }
        };
    }
}

