/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ISpriteRegister;
import forestry.api.core.ISpriteRegistry;
import forestry.api.core.ItemGroups;
import forestry.api.genetics.alleles.AlleleManager;
import forestry.apiculture.gui.ContainerHabitatLocator;
import forestry.apiculture.inventory.ItemInventoryHabitatLocator;
import forestry.apiculture.items.HabitatLocatorLogic;
import forestry.core.items.ItemWithGui;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemHabitatLocator
extends ItemWithGui
implements ISpriteRegister {
    private static final String iconName = "forestry:items/biomefinder";
    private final HabitatLocatorLogic locatorLogic = new HabitatLocatorLogic();

    public ItemHabitatLocator() {
        super(new Item.Properties().func_200916_a(ItemGroups.tabApiculture).func_200917_a(1));
    }

    public HabitatLocatorLogic getLocatorLogic() {
        return this.locatorLogic;
    }

    public void func_77663_a(ItemStack stack, World world, Entity player, int slot, boolean selected) {
        if (!world.field_72995_K) {
            this.locatorLogic.onUpdate(world, player);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerSprites(ISpriteRegistry registry) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemstack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(itemstack, world, list, flag);
        Minecraft minecraft = Minecraft.func_71410_x();
        if (world != null && minecraft.field_71439_g != null) {
            ClientPlayerEntity player = minecraft.field_71439_g;
            Biome currentBiome = player.field_70170_p.func_226691_t_(player.func_233580_cy_());
            EnumTemperature temperature = EnumTemperature.getFromBiome(currentBiome, player.func_233580_cy_());
            EnumHumidity humidity = EnumHumidity.getFromValue(currentBiome.func_76727_i());
            list.add((ITextComponent)new TranslationTextComponent("for.gui.currentBiome").func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_((ITextComponent)new TranslationTextComponent("biome." + currentBiome.getRegistryName().toString().replace(":", "."))));
            list.add((ITextComponent)new TranslationTextComponent("for.gui.temperature").func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_(AlleleManager.climateHelper.toDisplay(temperature)));
            list.add((ITextComponent)new TranslationTextComponent("for.gui.humidity").func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_(AlleleManager.climateHelper.toDisplay(humidity)));
        }
    }

    @Override
    public Container getContainer(int windowId, PlayerEntity player, ItemStack heldItem) {
        return new ContainerHabitatLocator(windowId, player, new ItemInventoryHabitatLocator(player, heldItem));
    }
}

