/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import forestry.api.apiculture.genetics.IBee;
import forestry.apiculture.network.packets.PacketHabitatBiomePointer;
import forestry.core.utils.NetworkUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class HabitatLocatorLogic {
    private static final int maxChecksPerTick = 100;
    private static final int maxSearchRadiusIterations = 500;
    private static final int spacing = 20;
    private static final int minBiomeRadius = 8;
    private static final Set<ResourceLocation> waterBiomes = new HashSet<ResourceLocation>();
    private static final Set<ResourceLocation> netherBiomes = new HashSet<ResourceLocation>();
    private static final Set<ResourceLocation> endBiomes = new HashSet<ResourceLocation>();
    private Set<ResourceLocation> targetBiomes = new HashSet<ResourceLocation>();
    private boolean biomeFound = false;
    private int searchRadiusIteration = 0;
    private int searchAngleIteration = 0;
    @Nullable
    private BlockPos searchCenter;

    @SubscribeEvent
    static void onBiomeLoaded(BiomeLoadingEvent event) {
        switch (event.getCategory()) {
            case BEACH: 
            case RIVER: 
            case OCEAN: {
                waterBiomes.add(event.getName());
                break;
            }
            case NETHER: {
                netherBiomes.add(event.getName());
                break;
            }
            case THEEND: {
                endBiomes.add(event.getName());
            }
        }
    }

    public boolean isBiomeFound() {
        return this.biomeFound;
    }

    public Set<ResourceLocation> getTargetBiomes() {
        return this.targetBiomes;
    }

    public void startBiomeSearch(IBee bee, PlayerEntity player) {
        this.targetBiomes = new HashSet<ResourceLocation>(bee.getSuitableBiomes());
        this.searchAngleIteration = 0;
        this.searchRadiusIteration = 0;
        this.biomeFound = false;
        this.searchCenter = player.func_233580_cy_();
        Biome currentBiome = player.field_70170_p.func_226691_t_(this.searchCenter);
        HabitatLocatorLogic.removeInvalidBiomes(currentBiome, this.targetBiomes);
        if (player.field_70170_p.field_72995_K) {
            // empty if block
        }
    }

    public void onUpdate(World world, Entity player) {
        if (world.field_72995_K) {
            return;
        }
        if (this.targetBiomes.isEmpty()) {
            return;
        }
        if (this.biomeFound && world.func_82737_E() % 20L != 0L) {
            return;
        }
        BlockPos target = this.findNearestBiome(player, this.targetBiomes);
        if (target != null && player instanceof ServerPlayerEntity) {
            NetworkUtil.sendToPlayer(new PacketHabitatBiomePointer(target), (PlayerEntity)((ServerPlayerEntity)player));
            this.biomeFound = true;
        }
    }

    @Nullable
    private BlockPos findNearestBiome(Entity player, Collection<ResourceLocation> biomesToSearch) {
        if (this.searchCenter == null) {
            return null;
        }
        BlockPos playerPos = player.func_233580_cy_();
        BlockPos coordinates = HabitatLocatorLogic.getChunkCoordinates(playerPos, player.field_70170_p, biomesToSearch);
        if (coordinates != null) {
            this.searchAngleIteration = 0;
            this.searchRadiusIteration = 0;
            return playerPos;
        }
        int radius = 20 * (this.searchRadiusIteration + 1);
        double angleSpacing = 2.0 * Math.asin(20.0 / (2.0 * (double)radius));
        angleSpacing = Math.PI * 2 / (double)Math.round(Math.PI * 2 / angleSpacing);
        for (int i = 0; i < 100; ++i) {
            int zOffset;
            double angle = angleSpacing * (double)this.searchAngleIteration;
            if (angle > Math.PI * 2) {
                this.searchAngleIteration = 0;
                ++this.searchRadiusIteration;
                if (this.searchRadiusIteration > 500) {
                    this.searchAngleIteration = 0;
                    this.searchRadiusIteration = 0;
                    this.searchCenter = playerPos;
                }
                return null;
            }
            ++this.searchAngleIteration;
            int xOffset = Math.round((float)((double)radius * Math.cos(angle)));
            BlockPos pos = this.searchCenter.func_177982_a(xOffset, 0, zOffset = Math.round((float)((double)radius * Math.sin(angle))));
            coordinates = HabitatLocatorLogic.getChunkCoordinates(pos, player.field_70170_p, biomesToSearch);
            if (coordinates == null) continue;
            this.searchAngleIteration = 0;
            this.searchRadiusIteration = 0;
            return coordinates;
        }
        return null;
    }

    @Nullable
    private static BlockPos getChunkCoordinates(BlockPos pos, World world, Collection<ResourceLocation> biomesToSearch) {
        Biome biome = world.func_226691_t_(pos);
        if (!biomesToSearch.contains(biome.getRegistryName())) {
            return null;
        }
        biome = world.func_226691_t_(pos.func_177982_a(-8, 0, 0));
        if (!biomesToSearch.contains(biome.getRegistryName())) {
            return null;
        }
        biome = world.func_226691_t_(pos.func_177982_a(8, 0, 0));
        if (!biomesToSearch.contains(biome.getRegistryName())) {
            return null;
        }
        biome = world.func_226691_t_(pos.func_177982_a(0, 0, -8));
        if (!biomesToSearch.contains(biome.getRegistryName())) {
            return null;
        }
        biome = world.func_226691_t_(pos.func_177982_a(0, 0, 8));
        if (!biomesToSearch.contains(biome.getRegistryName())) {
            return null;
        }
        return pos;
    }

    private static void removeInvalidBiomes(Biome currentBiome, Set<ResourceLocation> biomesToSearch) {
        biomesToSearch.removeAll(waterBiomes);
        if (currentBiome.func_201856_r() == Biome.Category.NETHER) {
            biomesToSearch.retainAll(netherBiomes);
        } else {
            biomesToSearch.removeAll(netherBiomes);
        }
        if (currentBiome.func_201856_r() == Biome.Category.THEEND) {
            biomesToSearch.retainAll(endBiomes);
        } else {
            biomesToSearch.removeAll(endBiomes);
        }
    }
}

