/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gui;

import forestry.apiculture.entities.MinecartEntityBeeHousingBase;
import forestry.apiculture.features.ApicultureContainers;
import forestry.apiculture.gui.ContainerBeeHelper;
import forestry.apiculture.gui.GuiBeeHousing;
import forestry.apiculture.gui.IContainerBeeHousing;
import forestry.apiculture.gui.IGuiBeeHousingDelegate;
import forestry.core.gui.ContainerAnalyzerProviderHelper;
import forestry.core.gui.ContainerEntity;
import forestry.core.gui.slots.SlotLockable;
import forestry.core.network.IStreamableGui;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.packets.PacketGuiUpdateEntity;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.network.PacketBuffer;

public class ContainerMinecartBeehouse
extends ContainerEntity<MinecartEntityBeeHousingBase>
implements IContainerBeeHousing {
    private final ContainerAnalyzerProviderHelper providerHelper;
    private final IGuiBeeHousingDelegate delegate;
    private final GuiBeeHousing.Icon icon;
    private int beeProgress = -1;

    public static ContainerMinecartBeehouse fromNetwork(int windowId, PlayerInventory playerInv, PacketBuffer extraData) {
        PacketBufferForestry buf = new PacketBufferForestry((ByteBuf)extraData);
        MinecartEntityBeeHousingBase e = (MinecartEntityBeeHousingBase)buf.readEntityById(playerInv.field_70458_d.field_70170_p);
        PlayerEntity player = playerInv.field_70458_d;
        boolean hasFrames = buf.readBoolean();
        GuiBeeHousing.Icon icon = (GuiBeeHousing.Icon)buf.readEnum(GuiBeeHousing.Icon.values());
        return new ContainerMinecartBeehouse(windowId, player.field_71071_by, e, hasFrames, icon);
    }

    public ContainerMinecartBeehouse(int windowId, PlayerInventory player, MinecartEntityBeeHousingBase entity, boolean hasFrames, GuiBeeHousing.Icon icon) {
        super(windowId, ApicultureContainers.BEEHOUSE_MINECART.containerType(), entity, player, 8, 108);
        this.providerHelper = new ContainerAnalyzerProviderHelper(this, player);
        ContainerBeeHelper.addSlots(this, entity, hasFrames);
        entity.getBeekeepingLogic().clearCachedValues();
        this.delegate = entity;
        this.icon = icon;
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        int beeProgress = ((MinecartEntityBeeHousingBase)this.entity).getBeekeepingLogic().getBeeProgressPercent();
        if (this.beeProgress != beeProgress) {
            this.beeProgress = beeProgress;
            PacketGuiUpdateEntity packet = new PacketGuiUpdateEntity((IStreamableGui)this.entity, this.entity);
            this.sendPacketToListeners(packet);
        }
    }

    @Override
    @Nullable
    public Slot getAnalyzerSlot() {
        return this.providerHelper.getAnalyzerSlot();
    }

    @Override
    protected void addSlot(PlayerInventory playerInventory, int slot, int x, int y) {
        this.func_75146_a(new SlotLockable((IInventory)playerInventory, slot, x, y));
    }

    @Override
    protected void addHotbarSlot(PlayerInventory playerInventory, int slot, int x, int y) {
        this.func_75146_a(new SlotLockable((IInventory)playerInventory, slot, x, y));
    }

    @Override
    public void handleSelectionRequest(ServerPlayerEntity player, int primary, int secondary) {
        this.providerHelper.analyzeSpecimen(secondary);
    }

    @Override
    public IGuiBeeHousingDelegate getDelegate() {
        return this.delegate;
    }

    @Override
    public GuiBeeHousing.Icon getIcon() {
        return this.icon;
    }
}

