/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.IApiaristTracker;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.apiculture.IBeekeepingMode;
import forestry.api.apiculture.genetics.BeeChromosomes;
import forestry.api.apiculture.genetics.EnumBeeType;
import forestry.api.apiculture.genetics.IBee;
import forestry.api.apiculture.genetics.IBeeRoot;
import forestry.api.genetics.IAlyzerPlugin;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IBreedingTrackerHandler;
import forestry.api.genetics.alleles.IAlleleForestrySpecies;
import forestry.api.genetics.gatgets.IDatabasePlugin;
import forestry.apiculture.BeeHousingListener;
import forestry.apiculture.BeeHousingModifier;
import forestry.apiculture.BeekeepingLogic;
import forestry.apiculture.genetics.ApiaristTracker;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.BeeAlyzerPlugin;
import forestry.apiculture.genetics.BeePlugin;
import forestry.core.genetics.root.BreedingTrackerManager;
import forestry.core.utils.Log;
import genetics.api.individual.IGenome;
import genetics.api.individual.IGenomeWrapper;
import genetics.api.individual.IIndividual;
import genetics.api.organism.IOrganismType;
import genetics.api.root.IRootContext;
import genetics.api.root.IndividualRoot;
import genetics.utils.AlleleUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BeeRoot
extends IndividualRoot<IBee>
implements IBeeRoot,
IBreedingTrackerHandler {
    private int beeSpeciesCount = -1;
    public static final String UID = "rootBees";
    private final List<IBeekeepingMode> beekeepingModes = new ArrayList<IBeekeepingMode>();
    @Nullable
    private static IBeekeepingMode activeBeekeepingMode;

    public BeeRoot(IRootContext<IBee> context) {
        super(context);
        BreedingTrackerManager.INSTANCE.registerTracker(UID, this);
    }

    @Override
    public Class<? extends IBee> getMemberClass() {
        return IBee.class;
    }

    @Override
    public int getSpeciesCount() {
        if (this.beeSpeciesCount < 0) {
            this.beeSpeciesCount = (int)AlleleUtils.filteredStream(BeeChromosomes.SPECIES).filter(IAlleleForestrySpecies::isCounted).count();
        }
        return this.beeSpeciesCount;
    }

    @Override
    public EnumBeeType getIconType() {
        return EnumBeeType.DRONE;
    }

    @Override
    public IOrganismType getTypeForMutation(int position) {
        switch (position) {
            case 0: {
                return EnumBeeType.PRINCESS;
            }
            case 1: {
                return EnumBeeType.DRONE;
            }
            case 2: {
                return EnumBeeType.QUEEN;
            }
        }
        return this.getIconType();
    }

    @Override
    public boolean isDrone(ItemStack stack) {
        Optional<IOrganismType> optional = this.getTypes().getType(stack);
        return optional.isPresent() && optional.get() == EnumBeeType.DRONE;
    }

    @Override
    public boolean isMated(ItemStack stack) {
        Optional<IOrganismType> optionalType = this.types.getType(stack);
        if (!optionalType.isPresent() || optionalType.get() != EnumBeeType.QUEEN) {
            return false;
        }
        CompoundNBT nbt = stack.func_77978_p();
        return nbt != null && nbt.func_74764_b("Mate");
    }

    @Override
    public IBee create(IGenome genome) {
        return new Bee(genome);
    }

    @Override
    public IBee create(IGenome genome, IGenome mate) {
        return new Bee(genome, mate);
    }

    @Override
    public IGenomeWrapper createWrapper(IGenome genome) {
        return () -> genome;
    }

    @Override
    public IBee create(CompoundNBT compound) {
        return new Bee(compound);
    }

    @Override
    public IBee getBee(World world, IGenome genome, IBee mate) {
        return new Bee(genome, mate);
    }

    @Override
    public void resetBeekeepingMode() {
        activeBeekeepingMode = null;
    }

    @Override
    public List<IBeekeepingMode> getBeekeepingModes() {
        return this.beekeepingModes;
    }

    @Override
    public IBeekeepingMode getBeekeepingMode(World world) {
        if (activeBeekeepingMode != null) {
            return activeBeekeepingMode;
        }
        IApiaristTracker tracker = this.getBreedingTracker((IWorld)world, null);
        String modeName = tracker.getModeName();
        IBeekeepingMode mode = this.getBeekeepingMode(modeName);
        Preconditions.checkNotNull((Object)mode);
        this.setBeekeepingMode(world, mode);
        Log.debug("Set beekeeping mode for a world to " + mode, new Object[0]);
        return activeBeekeepingMode;
    }

    @Override
    public void registerBeekeepingMode(IBeekeepingMode mode) {
        this.beekeepingModes.add(mode);
    }

    @Override
    public void setBeekeepingMode(World world, IBeekeepingMode mode) {
        Preconditions.checkNotNull((Object)world);
        Preconditions.checkNotNull((Object)mode);
        activeBeekeepingMode = mode;
        this.getBreedingTracker((IWorld)world, null).setModeName(mode.getName());
    }

    @Override
    public IBeekeepingMode getBeekeepingMode(String name) {
        for (IBeekeepingMode mode : this.beekeepingModes) {
            if (!mode.getName().equals(name) && !mode.getName().equals(name.toLowerCase(Locale.ENGLISH))) continue;
            return mode;
        }
        Log.debug("Failed to find a beekeeping mode called '{}', reverting to fallback.", name);
        return this.beekeepingModes.get(0);
    }

    @Override
    public IApiaristTracker getBreedingTracker(IWorld world, @Nullable GameProfile player) {
        return (IApiaristTracker)BreedingTrackerManager.INSTANCE.getTracker(this.getUID(), world, player);
    }

    @Override
    public String getFileName(@Nullable GameProfile profile) {
        return "ApiaristTracker." + (profile == null ? "common" : profile.getId());
    }

    @Override
    public IBreedingTracker createTracker(String fileName) {
        return new ApiaristTracker(fileName);
    }

    @Override
    public void populateTracker(IBreedingTracker tracker, @Nullable World world, @Nullable GameProfile profile) {
        if (!(tracker instanceof ApiaristTracker)) {
            return;
        }
        ApiaristTracker apiaristTracker = (ApiaristTracker)tracker;
        apiaristTracker.setWorld(world);
        apiaristTracker.setUsername(profile);
    }

    @Override
    public boolean isMember(IIndividual individual) {
        return individual instanceof IBee;
    }

    @Override
    public IBeekeepingLogic createBeekeepingLogic(IBeeHousing housing) {
        return new BeekeepingLogic(housing);
    }

    @Override
    public IBeeModifier createBeeHousingModifier(IBeeHousing housing) {
        return new BeeHousingModifier(housing);
    }

    @Override
    public IBeeListener createBeeHousingListener(IBeeHousing housing) {
        return new BeeHousingListener(housing);
    }

    @Override
    public IAlyzerPlugin getAlyzerPlugin() {
        return BeeAlyzerPlugin.INSTANCE;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IDatabasePlugin getSpeciesPlugin() {
        return BeePlugin.INSTANCE;
    }
}

