/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.genetics.BeeChromosomes;
import forestry.api.apiculture.genetics.EnumBeeType;
import forestry.api.apiculture.genetics.IAlleleBeeSpecies;
import forestry.api.apiculture.genetics.IAlleleBeeSpeciesBuilder;
import forestry.api.apiculture.genetics.IBee;
import forestry.api.apiculture.genetics.IBeeMutationBuilder;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.products.IMutableProductList;
import forestry.apiculture.features.ApicultureItems;
import forestry.apiculture.genetics.BeeBranchDefinition;
import forestry.apiculture.genetics.BeeHelper;
import forestry.apiculture.genetics.BeeVariation;
import forestry.apiculture.genetics.IBeeDefinition;
import forestry.apiculture.genetics.JubilanceProviderHermit;
import forestry.apiculture.genetics.alleles.AlleleEffects;
import forestry.apiculture.items.EnumHoneyComb;
import forestry.apiculture.items.EnumPollenCluster;
import forestry.core.features.CoreItems;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.core.items.definitions.EnumCraftingMaterial;
import genetics.api.alleles.IAlleleRegistry;
import genetics.api.alleles.IAlleleTemplate;
import genetics.api.alleles.IAlleleTemplateBuilder;
import genetics.api.individual.IGenome;
import genetics.api.root.ITemplateContainer;
import genetics.api.root.components.ComponentKey;
import genetics.api.root.components.ComponentKeys;
import genetics.api.root.components.IRootComponent;
import java.awt.Color;
import java.util.EnumSet;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.biome.Biome;

public enum BeeDefinition implements IBeeDefinition
{
    FOREST(BeeBranchDefinition.HONEY, "nigrocincta", true, new Color(1691884), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.HONEY, 1), Float.valueOf(0.3f));
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.FLOWERING, EnumAllele.Flowering.SLOWER);
            template.set(BeeChromosomes.FERTILITY, EnumAllele.Fertility.HIGH);
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    MEADOWS(BeeBranchDefinition.HONEY, "florea", true, new Color(15667998), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.HONEY, 1), Float.valueOf(0.3f));
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.FLOWERING, EnumAllele.Flowering.SLOWER);
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    COMMON(BeeBranchDefinition.HONEY, "cerana", true, new Color(0xB2B2B2), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.HONEY, 1), Float.valueOf(0.35f));
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.SPEED, EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            for (BeeDefinition hiveBee0 : overworldHiveBees) {
                for (BeeDefinition hiveBee1 : overworldHiveBees) {
                    if (hiveBee0.ordinal() >= hiveBee1.ordinal()) continue;
                    this.registerMutation(hiveBee0, hiveBee1, 15);
                }
            }
        }
    }
    ,
    CULTIVATED(BeeBranchDefinition.HONEY, "mellifera", true, new Color(5715180), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.HONEY, 1), Float.valueOf(0.4f));
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.SPEED, EnumAllele.Speed.FAST);
            template.set(BeeChromosomes.LIFESPAN, EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            for (BeeDefinition hiveBee : overworldHiveBees) {
                this.registerMutation(COMMON, hiveBee, 12);
            }
        }
    }
    ,
    NOBLE(BeeBranchDefinition.NOBLE, "nobilis", false, new Color(15505945), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.DRIPPING, 1), Float.valueOf(0.2f));
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.SPEED, EnumAllele.Speed.SLOWER);
            template.set(BeeChromosomes.LIFESPAN, EnumAllele.Lifespan.SHORT);
            template.set(BeeChromosomes.FLOWERING, EnumAllele.Flowering.SLOW);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(COMMON, CULTIVATED, 10);
        }
    }
    ,
    MAJESTIC(BeeBranchDefinition.NOBLE, "regalis", true, new Color(0x7F0000), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.DRIPPING), Float.valueOf(0.3f));
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.SPEED, EnumAllele.Speed.NORMAL);
            template.set(BeeChromosomes.LIFESPAN, EnumAllele.Lifespan.SHORTENED);
            template.set(BeeChromosomes.FERTILITY, EnumAllele.Fertility.MAXIMUM);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(NOBLE, CULTIVATED, 8);
        }
    }
    ,
    IMPERIAL(BeeBranchDefinition.NOBLE, "imperatorius", false, new Color(10739759), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.DRIPPING, 1), Float.valueOf(0.2f)).addProduct(ApicultureItems.ROYAL_JELLY::stack, Float.valueOf(0.15f)).setHasEffect();
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.SPEED, EnumAllele.Speed.SLOWER);
            template.set(BeeChromosomes.LIFESPAN, EnumAllele.Lifespan.NORMAL);
            template.set(BeeChromosomes.EFFECT, AlleleEffects.effectBeatific);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(NOBLE, MAJESTIC, 8);
        }
    }
    ,
    DILIGENT(BeeBranchDefinition.INDUSTRIOUS, "sedulus", false, new Color(12720620), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.STRINGY, 1), Float.valueOf(0.2f));
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.SPEED, EnumAllele.Speed.SLOWER);
            template.set(BeeChromosomes.LIFESPAN, EnumAllele.Lifespan.SHORT);
            template.set(BeeChromosomes.FLOWERING, EnumAllele.Flowering.SLOW);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(COMMON, CULTIVATED, 10);
        }
    }
    ,
    UNWEARY(BeeBranchDefinition.INDUSTRIOUS, "assiduus", true, new Color(1698906), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.STRINGY, 1), Float.valueOf(0.3f));
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.SPEED, EnumAllele.Speed.NORMAL);
            template.set(BeeChromosomes.LIFESPAN, EnumAllele.Lifespan.SHORTENED);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(DILIGENT, CULTIVATED, 8);
        }
    }
    ,
    INDUSTRIOUS(BeeBranchDefinition.INDUSTRIOUS, "industria", false, new Color(0xFFFFFF), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.STRINGY, 1), Float.valueOf(0.2f)).addProduct(() -> ApicultureItems.POLLEN_CLUSTER.stack(EnumPollenCluster.NORMAL), Float.valueOf(0.15f)).setHasEffect();
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.SPEED, EnumAllele.Speed.SLOWER);
            template.set(BeeChromosomes.LIFESPAN, EnumAllele.Lifespan.NORMAL);
            template.set(BeeChromosomes.FLOWERING, EnumAllele.Flowering.FAST);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(DILIGENT, UNWEARY, 8);
        }
    }
    ,
    STEADFAST(BeeBranchDefinition.HEROIC, "legio", false, new Color(5057301), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.COCOA, 1), Float.valueOf(0.2f)).setHasEffect();
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.SPEED, EnumAllele.Speed.SLOWER);
            template.set(BeeChromosomes.LIFESPAN, EnumAllele.Lifespan.NORMAL);
            template.set(BeeChromosomes.NEVER_SLEEPS, true);
            template.set(BeeChromosomes.CAVE_DWELLING, true);
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    VALIANT(BeeBranchDefinition.HEROIC, "centurio", true, new Color(6450141), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.COCOA, 1), Float.valueOf(0.3f)).addSpecialty(() -> new ItemStack((IItemProvider)Items.field_151102_aT), Float.valueOf(0.15f));
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.SPEED, EnumAllele.Speed.SLOW);
            template.set(BeeChromosomes.LIFESPAN, EnumAllele.Lifespan.LONG);
            template.set(BeeChromosomes.NEVER_SLEEPS, true);
            template.set(BeeChromosomes.CAVE_DWELLING, true);
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    HEROIC(BeeBranchDefinition.HEROIC, "kraphti", false, new Color(11785700), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.COCOA, 1), Float.valueOf(0.4f)).setHasEffect();
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.SPEED, EnumAllele.Speed.SLOW);
            template.set(BeeChromosomes.LIFESPAN, EnumAllele.Lifespan.LONG);
            template.set(BeeChromosomes.NEVER_SLEEPS, true);
            template.set(BeeChromosomes.CAVE_DWELLING, true);
            template.set(BeeChromosomes.EFFECT, AlleleEffects.effectHeroic);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(STEADFAST, VALIANT, 6).restrictBiomeType(Biome.Category.FOREST);
        }
    }
    ,
    SINISTER(BeeBranchDefinition.INFERNAL, "caecus", false, new Color(11785700), new Color(10101539)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            ((IAlleleBeeSpeciesBuilder)beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.SIMMERING, 1), Float.valueOf(0.45f)).setTemperature(EnumTemperature.HELLISH)).setHumidity(EnumHumidity.ARID);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.SPEED, EnumAllele.Speed.SLOWER);
            template.set(BeeChromosomes.LIFESPAN, EnumAllele.Lifespan.NORMAL);
            template.set(BeeChromosomes.EFFECT, AlleleEffects.effectAggressive);
        }

        @Override
        protected void registerMutations() {
            for (BeeDefinition parent2 : EnumSet.of(MODEST, TROPICAL)) {
                this.registerMutation(CULTIVATED, parent2, 60).restrictBiomeType(Biome.Category.NETHER);
            }
        }
    }
    ,
    FIENDISH(BeeBranchDefinition.INFERNAL, "diabolus", true, new Color(14139109), new Color(10101539)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            ((IAlleleBeeSpeciesBuilder)beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.SIMMERING, 1), Float.valueOf(0.55f)).addProduct(CoreItems.ASH::stack, Float.valueOf(0.15f)).setTemperature(EnumTemperature.HELLISH)).setHumidity(EnumHumidity.ARID);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.SPEED, EnumAllele.Speed.NORMAL);
            template.set(BeeChromosomes.LIFESPAN, EnumAllele.Lifespan.LONG);
            template.set(BeeChromosomes.EFFECT, AlleleEffects.effectAggressive);
        }

        @Override
        protected void registerMutations() {
            for (BeeDefinition parent2 : EnumSet.of(CULTIVATED, MODEST, TROPICAL)) {
                this.registerMutation(SINISTER, parent2, 40).restrictBiomeType(Biome.Category.NETHER);
            }
        }
    }
    ,
    DEMONIC(BeeBranchDefinition.INFERNAL, "draco", false, new Color(16049152), new Color(10101539)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            ((IAlleleBeeSpeciesBuilder)((IAlleleBeeSpeciesBuilder)beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.SIMMERING, 1), Float.valueOf(0.45f)).addProduct(() -> new ItemStack((IItemProvider)Items.field_151114_aO), Float.valueOf(0.15f)).setHasEffect()).setTemperature(EnumTemperature.HELLISH)).setHumidity(EnumHumidity.ARID);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.SPEED, EnumAllele.Speed.SLOWER);
            template.set(BeeChromosomes.LIFESPAN, EnumAllele.Lifespan.LONGER);
            template.set(BeeChromosomes.EFFECT, AlleleEffects.effectIgnition);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(SINISTER, FIENDISH, 25).restrictBiomeType(Biome.Category.NETHER);
        }
    }
    ,
    MODEST(BeeBranchDefinition.AUSTERE, "modicus", false, new Color(12959366), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            ((IAlleleBeeSpeciesBuilder)beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.PARCHED, 1), Float.valueOf(0.2f)).setTemperature(EnumTemperature.HOT)).setHumidity(EnumHumidity.ARID);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.SPEED, EnumAllele.Speed.SLOWER);
            template.set(BeeChromosomes.LIFESPAN, EnumAllele.Lifespan.SHORT);
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    FRUGAL(BeeBranchDefinition.AUSTERE, "permodestus", true, new Color(15260849), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            ((IAlleleBeeSpeciesBuilder)beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.PARCHED, 1), Float.valueOf(0.3f)).setTemperature(EnumTemperature.HOT)).setHumidity(EnumHumidity.ARID);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.SPEED, EnumAllele.Speed.NORMAL);
            template.set(BeeChromosomes.LIFESPAN, EnumAllele.Lifespan.LONG);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(MODEST, SINISTER, 16).restrictTemperature(EnumTemperature.HOT, EnumTemperature.HELLISH).restrictHumidity(EnumHumidity.ARID);
            this.registerMutation(MODEST, FIENDISH, 10).restrictTemperature(EnumTemperature.HOT, EnumTemperature.HELLISH).restrictHumidity(EnumHumidity.ARID);
        }
    }
    ,
    AUSTERE(BeeBranchDefinition.AUSTERE, "correpere", false, new Color(16775874), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            ((IAlleleBeeSpeciesBuilder)((IAlleleBeeSpeciesBuilder)beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.PARCHED, 1), Float.valueOf(0.2f)).addSpecialty(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.POWDERY, 1), Float.valueOf(0.5f)).setHasEffect()).setTemperature(EnumTemperature.HOT)).setHumidity(EnumHumidity.ARID);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.SPEED, EnumAllele.Speed.SLOWEST);
            template.set(BeeChromosomes.LIFESPAN, EnumAllele.Lifespan.LONGER);
            template.set(BeeChromosomes.TEMPERATURE_TOLERANCE, EnumAllele.Tolerance.DOWN_2);
            template.set(BeeChromosomes.EFFECT, AlleleEffects.effectCreeper);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(MODEST, FRUGAL, 8).restrictTemperature(EnumTemperature.HOT, EnumTemperature.HELLISH).restrictHumidity(EnumHumidity.ARID);
        }
    }
    ,
    TROPICAL(BeeBranchDefinition.TROPICAL, "mendelia", false, new Color(3637280), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            ((IAlleleBeeSpeciesBuilder)beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.SILKY, 1), Float.valueOf(0.2f)).setTemperature(EnumTemperature.WARM)).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.SPEED, EnumAllele.Speed.SLOWER);
            template.set(BeeChromosomes.LIFESPAN, EnumAllele.Lifespan.SHORT);
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    EXOTIC(BeeBranchDefinition.TROPICAL, "darwini", true, new Color(3164419), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            ((IAlleleBeeSpeciesBuilder)beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.SILKY, 1), Float.valueOf(0.3f)).setTemperature(EnumTemperature.WARM)).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.SPEED, EnumAllele.Speed.NORMAL);
            template.set(BeeChromosomes.LIFESPAN, EnumAllele.Lifespan.LONG);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(AUSTERE, TROPICAL, 12);
        }
    }
    ,
    EDENIC(BeeBranchDefinition.TROPICAL, "humboldti", false, new Color(3751181), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            ((IAlleleBeeSpeciesBuilder)((IAlleleBeeSpeciesBuilder)beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.SILKY, 1), Float.valueOf(0.2f)).setHasEffect()).setTemperature(EnumTemperature.WARM)).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.SPEED, EnumAllele.Speed.SLOWEST);
            template.set(BeeChromosomes.LIFESPAN, EnumAllele.Lifespan.LONGER);
            template.set(BeeChromosomes.TEMPERATURE_TOLERANCE, EnumAllele.Tolerance.BOTH_2);
            template.set(BeeChromosomes.EFFECT, AlleleEffects.effectExploration);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(EXOTIC, TROPICAL, 8);
        }
    }
    ,
    ENDED(BeeBranchDefinition.END, "notchi", false, new Color(14711290), new Color(0xD9DE9E)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.MYSTERIOUS, 1), Float.valueOf(0.3f)).setTemperature(EnumTemperature.COLD);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    SPECTRAL(BeeBranchDefinition.END, "idolum", true, new Color(11111405), new Color(0xD9DE9E)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.MYSTERIOUS, 1), Float.valueOf(0.5f)).setTemperature(EnumTemperature.COLD);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.EFFECT, AlleleEffects.effectReanimation);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(HERMITIC, ENDED, 4);
        }
    }
    ,
    PHANTASMAL(BeeBranchDefinition.END, "lemur", false, new Color(13369594), new Color(0xD9DE9E)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            ((IAlleleBeeSpeciesBuilder)beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.MYSTERIOUS, 1), Float.valueOf(0.4f)).setHasEffect()).setTemperature(EnumTemperature.COLD);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.SPEED, EnumAllele.Speed.SLOWEST);
            template.set(BeeChromosomes.LIFESPAN, EnumAllele.Lifespan.LONGEST);
            template.set(BeeChromosomes.EFFECT, AlleleEffects.effectResurrection);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(SPECTRAL, ENDED, 2);
        }
    }
    ,
    WINTRY(BeeBranchDefinition.FROZEN, "brumalis", false, new Color(10551240), new Color(14349811)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.FROZEN, 1), Float.valueOf(0.3f)).setTemperature(EnumTemperature.ICY);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.SPEED, EnumAllele.Speed.SLOWER);
            template.set(BeeChromosomes.LIFESPAN, EnumAllele.Lifespan.SHORT);
            template.set(BeeChromosomes.FERTILITY, EnumAllele.Fertility.MAXIMUM);
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    ICY(BeeBranchDefinition.FROZEN, "coagulis", true, new Color(0xA0FFFF), new Color(14349811)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.FROZEN, 1), Float.valueOf(0.2f)).addProduct(() -> CoreItems.CRAFTING_MATERIALS.stack(EnumCraftingMaterial.ICE_SHARD, 1), Float.valueOf(0.2f)).setTemperature(EnumTemperature.ICY);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.SPEED, EnumAllele.Speed.SLOW);
            template.set(BeeChromosomes.LIFESPAN, EnumAllele.Lifespan.SHORT);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(INDUSTRIOUS, WINTRY, 12).restrictTemperature(EnumTemperature.ICY, EnumTemperature.COLD);
        }
    }
    ,
    GLACIAL(BeeBranchDefinition.FROZEN, "glacialis", false, new Color(0xEFFFFF), new Color(14349811)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            ((IAlleleBeeSpeciesBuilder)beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.FROZEN, 1), Float.valueOf(0.2f)).addProduct(() -> CoreItems.CRAFTING_MATERIALS.stack(EnumCraftingMaterial.ICE_SHARD, 1), Float.valueOf(0.4f)).setTemperature(EnumTemperature.ICY)).setHasEffect();
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.SPEED, EnumAllele.Speed.SLOWER);
            template.set(BeeChromosomes.LIFESPAN, EnumAllele.Lifespan.SHORT);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(ICY, WINTRY, 8).restrictTemperature(EnumTemperature.ICY, EnumTemperature.COLD);
        }
    }
    ,
    VINDICTIVE(BeeBranchDefinition.VENGEFUL, "ultio", false, new Color(15400947), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.IRRADIATED, 1), Float.valueOf(0.25f)).setIsNotCounted();
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.SPEED, EnumAllele.Speed.SLOWER);
            template.set(BeeChromosomes.LIFESPAN, EnumAllele.Lifespan.NORMAL);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(MONASTIC, DEMONIC, 4).setIsSecret();
        }
    }
    ,
    VENGEFUL(BeeBranchDefinition.VENGEFUL, "punire", false, new Color(12770816), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.IRRADIATED, 1), Float.valueOf(0.4f)).setIsNotCounted();
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.SPEED, EnumAllele.Speed.NORMAL);
            template.set(BeeChromosomes.LIFESPAN, EnumAllele.Lifespan.LONGER);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(DEMONIC, VINDICTIVE, 8).setIsSecret();
            this.registerMutation(MONASTIC, VINDICTIVE, 8).setIsSecret();
        }
    }
    ,
    AVENGING(BeeBranchDefinition.VENGEFUL, "hostimentum", false, new Color(0xDDFF00), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            ((IAlleleBeeSpeciesBuilder)beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.IRRADIATED, 1), Float.valueOf(0.4f)).setHasEffect()).setIsNotCounted();
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.SPEED, EnumAllele.Speed.SLOWEST);
            template.set(BeeChromosomes.LIFESPAN, EnumAllele.Lifespan.LONGEST);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(VENGEFUL, VINDICTIVE, 4);
        }
    }
    ,
    LEPORINE(BeeBranchDefinition.FESTIVE, "lepus", false, new Color(0xFEFF8F), new Color(3987287)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            ((IAlleleBeeSpeciesBuilder)beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.SILKY, 1), Float.valueOf(0.3f)).addProduct(() -> new ItemStack((IItemProvider)Items.field_151110_aK), Float.valueOf(0.1f)).setHasEffect()).setIsNotCounted();
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.EFFECT, AlleleEffects.effectFestiveEaster);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(MEADOWS, FOREST, 10).restrictDateRange(3, 29, 4, 15).setIsSecret();
        }

        @Override
        protected boolean isSecret() {
            return true;
        }
    }
    ,
    MERRY(BeeBranchDefinition.FESTIVE, "feliciter", false, new Color(0xFFFFFF), new Color(0xD40000)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            ((IAlleleBeeSpeciesBuilder)((IAlleleBeeSpeciesBuilder)beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.FROZEN, 1), Float.valueOf(0.3f)).addProduct(() -> CoreItems.CRAFTING_MATERIALS.stack(EnumCraftingMaterial.ICE_SHARD, 1), Float.valueOf(0.2f)).setTemperature(EnumTemperature.ICY)).setHasEffect()).setIsNotCounted();
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.NEVER_SLEEPS, true);
            template.set(BeeChromosomes.EFFECT, AlleleEffects.effectSnowing);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(WINTRY, FOREST, 10).restrictDateRange(12, 21, 12, 27).setIsSecret();
        }

        @Override
        protected boolean isSecret() {
            return true;
        }
    }
    ,
    TIPSY(BeeBranchDefinition.FESTIVE, "ebrius", false, new Color(0xFFFFFF), new Color(12720620)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            ((IAlleleBeeSpeciesBuilder)((IAlleleBeeSpeciesBuilder)beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.FROZEN, 1), Float.valueOf(0.3f)).addProduct(() -> CoreItems.CRAFTING_MATERIALS.stack(EnumCraftingMaterial.ICE_SHARD, 1), Float.valueOf(0.2f)).setTemperature(EnumTemperature.ICY)).setHasEffect()).setIsNotCounted();
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.NEVER_SLEEPS, true);
            template.set(BeeChromosomes.EFFECT, AlleleEffects.effectDrunkard);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(WINTRY, MEADOWS, 10).restrictDateRange(12, 27, 1, 2).setIsSecret();
        }

        @Override
        protected boolean isSecret() {
            return true;
        }
    }
    ,
    TRICKY(BeeBranchDefinition.FESTIVE, "libita", false, new Color(4800827), new Color(16738816)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            ((IAlleleBeeSpeciesBuilder)beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.HONEY, 1), Float.valueOf(0.4f)).addProduct(() -> new ItemStack((IItemProvider)Items.field_151106_aX), Float.valueOf(0.15f)).addSpecialty(() -> new ItemStack((IItemProvider)Items.field_196182_dv, 1), Float.valueOf(0.02f)).addSpecialty(() -> new ItemStack((IItemProvider)Items.field_196186_dz, 1), Float.valueOf(0.02f)).addSpecialty(() -> new ItemStack((IItemProvider)Items.field_196185_dy, 1), Float.valueOf(0.02f)).addSpecialty(() -> new ItemStack((IItemProvider)Items.field_196184_dx, 1), Float.valueOf(0.02f)).setHasEffect()).setIsNotCounted();
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.NEVER_SLEEPS, true);
            template.set(BeeChromosomes.TOLERATES_RAIN, true);
            template.set(BeeChromosomes.FLOWER_PROVIDER, EnumAllele.Flowers.GOURD);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(SINISTER, COMMON, 10).restrictDateRange(10, 15, 11, 3).setIsSecret();
        }

        @Override
        protected boolean isSecret() {
            return true;
        }
    }
    ,
    RURAL(BeeBranchDefinition.AGRARIAN, "rustico", false, new Color(0xFEFF8F), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.WHEATEN, 1), Float.valueOf(0.2f));
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(MEADOWS, DILIGENT, 12).restrictBiomeType(Biome.Category.PLAINS);
        }
    }
    ,
    FARMERLY(BeeBranchDefinition.AGRARIAN, "arator", true, new Color(13866792), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.WHEATEN, 1), Float.valueOf(0.27f));
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.SPEED, EnumAllele.Speed.SLOW);
            template.set(BeeChromosomes.TERRITORY, EnumAllele.Territory.LARGE);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(RURAL, UNWEARY, 10).restrictBiomeType(Biome.Category.PLAINS);
        }
    }
    ,
    AGRARIAN(BeeBranchDefinition.AGRARIAN, "arator", true, new Color(16763509), new Color(16769095)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.WHEATEN, 1), Float.valueOf(0.35f)).setHasEffect();
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.SPEED, EnumAllele.Speed.SLOW);
            template.set(BeeChromosomes.HUMIDITY_TOLERANCE, EnumAllele.Tolerance.BOTH_2);
            template.set(BeeChromosomes.EFFECT, AlleleEffects.effectFertile);
            template.set(BeeChromosomes.TERRITORY, EnumAllele.Territory.LARGE);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(FARMERLY, INDUSTRIOUS, 6).restrictBiomeType(Biome.Category.PLAINS);
        }
    }
    ,
    MARSHY(BeeBranchDefinition.BOGGY, "adorasti", true, new Color(5531174), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.MOSSY, 1), Float.valueOf(0.3f)).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    MIRY(BeeBranchDefinition.BOGGY, "humidium", true, new Color(9613122), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.MOSSY, 1), Float.valueOf(0.36f)).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.FERTILITY, EnumAllele.Fertility.MAXIMUM);
            template.set(BeeChromosomes.TOLERATES_RAIN, true);
            template.set(BeeChromosomes.NEVER_SLEEPS, true);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(MARSHY, NOBLE, 15).restrictTemperature(EnumTemperature.WARM).restrictHumidity(EnumHumidity.DAMP);
        }
    }
    ,
    BOGGY(BeeBranchDefinition.BOGGY, "paluster", true, new Color(6916424), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.MOSSY, 1), Float.valueOf(0.39f)).addSpecialty(CoreItems.PEAT::stack, Float.valueOf(0.08f)).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.TOLERATES_RAIN, true);
            template.set(BeeChromosomes.NEVER_SLEEPS, true);
            template.set(BeeChromosomes.EFFECT, AlleleEffects.effectMycophilic);
            template.set(BeeChromosomes.TERRITORY, EnumAllele.Territory.LARGER);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(MARSHY, MIRY, 9).restrictTemperature(EnumTemperature.WARM).restrictHumidity(EnumHumidity.DAMP);
        }
    }
    ,
    MONASTIC(BeeBranchDefinition.MONASTIC, "monachus", false, new Color(4339484), new Color(16775094)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.WHEATEN, 1), Float.valueOf(0.3f)).addSpecialty(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.MELLOW, 1), Float.valueOf(0.1f)).setJubilanceProvider(new JubilanceProviderHermit());
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    SECLUDED(BeeBranchDefinition.MONASTIC, "contractus", true, new Color(8087092), new Color(16775094)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addSpecialty(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.MELLOW, 1), Float.valueOf(0.2f)).setJubilanceProvider(new JubilanceProviderHermit());
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.FLOWERING, EnumAllele.Flowering.FASTEST);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(MONASTIC, AUSTERE, 12);
        }
    }
    ,
    HERMITIC(BeeBranchDefinition.MONASTIC, "anachoreta", false, new Color(16766060), new Color(16775094)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addSpecialty(() -> ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.MELLOW, 1), Float.valueOf(0.2f)).setJubilanceProvider(new JubilanceProviderHermit()).setHasEffect();
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(BeeChromosomes.FLOWERING, EnumAllele.Flowering.FASTEST);
            template.set(BeeChromosomes.EFFECT, AlleleEffects.effectRepulsion);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(MONASTIC, SECLUDED, 8);
        }
    };

    private static final EnumSet<BeeDefinition> overworldHiveBees;
    private final BeeBranchDefinition branch;
    private final IAlleleBeeSpecies species;
    @Nullable
    private IAlleleTemplate template;
    @Nullable
    private IGenome genome;

    private BeeDefinition(BeeBranchDefinition branch, String binomial, boolean dominant, Color primary, Color secondary) {
        String lowercaseName = this.toString().toLowerCase(Locale.ENGLISH);
        String species = "species_" + lowercaseName;
        String description = "for.description." + species;
        String name = "for.bees.species." + lowercaseName;
        this.branch = branch;
        IAlleleBeeSpeciesBuilder speciesBuilder = (IAlleleBeeSpeciesBuilder)((IAlleleBeeSpeciesBuilder)((IAlleleBeeSpeciesBuilder)((IAlleleBeeSpeciesBuilder)((IAlleleBeeSpeciesBuilder)BeeManager.beeFactory.createSpecies("forestry", species, lowercaseName).setDominant(dominant)).setTranslationKey(name)).setColour(primary.getRGB(), secondary.getRGB()).setBranch(branch.getBranch())).setBinomial(binomial)).setDescriptionKey(description);
        if (this.isSecret()) {
            speciesBuilder.setIsSecret();
        }
        this.setSpeciesProperties(speciesBuilder);
        this.species = speciesBuilder.build();
    }

    protected abstract void setSpeciesProperties(IAlleleBeeSpeciesBuilder var1);

    protected abstract void setAlleles(IAlleleTemplateBuilder var1);

    protected abstract void registerMutations();

    protected void addProducts(IMutableProductList products) {
    }

    protected boolean isSecret() {
        return false;
    }

    public static void initBees() {
        for (BeeDefinition bee : BeeDefinition.values()) {
            bee.registerMutations();
        }
    }

    @Override
    public void registerAlleles(IAlleleRegistry registry) {
        registry.registerAllele(this.species, BeeChromosomes.SPECIES);
    }

    @Override
    public <C extends IRootComponent<IBee>> void onComponentSetup(C component) {
        ComponentKey key = component.getKey();
        if (key == ComponentKeys.TEMPLATES) {
            ITemplateContainer registry = (ITemplateContainer)component;
            IAlleleTemplateBuilder templateBuilder = this.branch.getTemplateBuilder();
            templateBuilder.set(BeeChromosomes.SPECIES, this.species);
            this.setAlleles(templateBuilder);
            this.template = templateBuilder.build();
            this.genome = this.template.toGenome();
            registry.registerTemplate(this.template);
        }
    }

    protected final IBeeMutationBuilder registerMutation(BeeDefinition parent1, BeeDefinition parent2, int chance) {
        return BeeManager.beeMutationFactory.createMutation(parent1.species, parent2.species, this.getTemplate().alleles(), chance);
    }

    @Override
    public final IAlleleTemplate getTemplate() {
        return this.template;
    }

    @Override
    public final IGenome getGenome() {
        return this.genome;
    }

    @Override
    public IAlleleBeeSpecies getSpecies() {
        return this.species;
    }

    @Override
    public ItemStack getMemberStack(EnumBeeType beeType) {
        IBee bee = this.createIndividual();
        return BeeHelper.getRoot().getTypes().createStack(bee, beeType);
    }

    @Override
    public IBee createIndividual() {
        return this.getTemplate().toIndividual(BeeHelper.getRoot());
    }

    public final IBeeDefinition getRainResist() {
        return new BeeVariation.RainResist(this);
    }

    static {
        overworldHiveBees = EnumSet.of(FOREST, new BeeDefinition[]{MARSHY, MEADOWS, MODEST, TROPICAL, WINTRY});
    }
}

