/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IApiaristTracker;
import forestry.api.apiculture.genetics.BeeChromosomes;
import forestry.api.apiculture.genetics.IBeeRoot;
import forestry.api.genetics.IBreedingTracker;
import forestry.apiculture.ModuleApiculture;
import forestry.core.genetics.BreedingTracker;
import genetics.api.individual.IIndividual;
import genetics.api.mutation.IMutationContainer;
import genetics.api.root.components.ComponentKeys;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.IWorld;

public class ApiaristTracker
extends BreedingTracker
implements IApiaristTracker {
    private int queensTotal = 0;
    private int dronesTotal = 0;
    private int princessesTotal = 0;

    public ApiaristTracker(String s) {
        super(s, ModuleApiculture.beekeepingMode);
    }

    @Override
    public void func_76184_a(CompoundNBT compoundNBT) {
        this.queensTotal = compoundNBT.func_74762_e("QueensTotal");
        this.princessesTotal = compoundNBT.func_74762_e("PrincessesTotal");
        this.dronesTotal = compoundNBT.func_74762_e("DronesTotal");
        super.func_76184_a(compoundNBT);
    }

    @Override
    public CompoundNBT func_189551_b(CompoundNBT compoundnbt) {
        compoundnbt.func_74768_a("QueensTotal", this.queensTotal);
        compoundnbt.func_74768_a("PrincessesTotal", this.princessesTotal);
        compoundnbt.func_74768_a("DronesTotal", this.dronesTotal);
        compoundnbt = super.func_189551_b(compoundnbt);
        return compoundnbt;
    }

    @Override
    public void registerPickup(IIndividual individual) {
        IBeeRoot speciesRoot = (IBeeRoot)individual.getRoot();
        if (!speciesRoot.getUID().equals(this.speciesRootUID())) {
            return;
        }
        if (!individual.isPureBred(BeeChromosomes.SPECIES)) {
            return;
        }
        IMutationContainer container = (IMutationContainer)speciesRoot.getComponent(ComponentKeys.MUTATIONS);
        if (!container.getCombinations(individual.getGenome().getPrimary()).isEmpty()) {
            return;
        }
        this.registerSpecies(individual.getGenome().getPrimary());
    }

    @Override
    public void registerQueen(IIndividual bee) {
        ++this.queensTotal;
    }

    @Override
    public int getQueenCount() {
        return this.queensTotal;
    }

    @Override
    public void registerPrincess(IIndividual bee) {
        ++this.princessesTotal;
        this.registerBirth(bee);
    }

    @Override
    public int getPrincessCount() {
        return this.princessesTotal;
    }

    @Override
    public void registerDrone(IIndividual bee) {
        ++this.dronesTotal;
        this.registerBirth(bee);
    }

    @Override
    public int getDroneCount() {
        return this.dronesTotal;
    }

    @Override
    protected IBreedingTracker getBreedingTracker(PlayerEntity player) {
        return BeeManager.beeRoot.getBreedingTracker((IWorld)player.field_70170_p, player.func_146103_bH());
    }

    @Override
    protected String speciesRootUID() {
        return "rootBees";
    }
}

