/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.arboriculture.genetics;

import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.ITreeGenData;
import forestry.api.arboriculture.genetics.ITreeRoot;
import forestry.api.arboriculture.genetics.TreeChromosomes;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.products.IProductList;
import genetics.api.individual.IChromosomeType;
import genetics.api.individual.IIndividual;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface ITree
extends IIndividual,
ITreeGenData {
    @Override
    public ITreeRoot getRoot();

    public boolean matchesTemplateGenome();

    public IEffectData[] doEffect(IEffectData[] var1, World var2, BlockPos var3);

    @OnlyIn(value=Dist.CLIENT)
    public IEffectData[] doFX(IEffectData[] var1, World var2, BlockPos var3);

    public List<ITree> getSaplings(World var1, @Nullable GameProfile var2, BlockPos var3, float var4);

    public IProductList getProducts();

    public IProductList getSpecialties();

    public NonNullList<ItemStack> produceStacks(World var1, BlockPos var2, int var3);

    public boolean canStay(IBlockReader var1, BlockPos var2);

    @Override
    @Nullable
    public BlockPos canGrow(IWorld var1, BlockPos var2, int var3, int var4);

    public int getRequiredMaturity();

    public int getResilience();

    @Override
    public int getGirth();

    public Feature<NoFeatureConfig> getTreeGenerator(ISeedReader var1, BlockPos var2, boolean var3);

    @Override
    public ITree copy();

    @Override
    public boolean isPureBred(IChromosomeType var1);

    public boolean canBearFruit();

    default public boolean hasEffect() {
        return this.getGenome().getActiveAllele(TreeChromosomes.SPECIES).hasEffect();
    }

    default public boolean isSecret() {
        return this.getGenome().getActiveAllele(TreeChromosomes.SPECIES).isSecret();
    }
}

