/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.render;

import com.inventorypets.entities.SiamesePetEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.CatModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.IRenderFactory;

@OnlyIn(value=Dist.CLIENT)
public class SiamesePetRenderer
extends MobRenderer<SiamesePetEntity, CatModel<SiamesePetEntity>> {
    private static final ResourceLocation petTextures = new ResourceLocation("inventorypets:textures/entity/siamese_pet.png");

    public SiamesePetRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, (EntityModel)new CatModel(0.0f), 0.4f);
    }

    public ResourceLocation getEntityTexture(SiamesePetEntity entity) {
        return petTextures;
    }

    protected void preRenderCallback(SiamesePetEntity entitylivingbaseIn, MatrixStack matrixStackIn, float partialTickTime) {
        super.func_225620_a_((LivingEntity)entitylivingbaseIn, matrixStackIn, partialTickTime);
        matrixStackIn.func_227862_a_(0.8f, 0.8f, 0.8f);
    }

    protected void applyRotations(SiamesePetEntity entityLiving, MatrixStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        super.func_225621_a_((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
        float f = entityLiving.func_213408_v(partialTicks);
        if (f > 0.0f) {
            matrixStackIn.func_227861_a_((double)(0.4f * f), (double)(0.15f * f), (double)(0.1f * f));
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(MathHelper.func_219805_h((float)f, (float)0.0f, (float)90.0f)));
            BlockPos blockpos = entityLiving.func_233580_cy_();
            for (PlayerEntity playerentity : entityLiving.field_70170_p.func_217357_a(PlayerEntity.class, new AxisAlignedBB(blockpos).func_72314_b(2.0, 2.0, 2.0))) {
                if (!playerentity.func_70608_bn()) continue;
                matrixStackIn.func_227861_a_((double)(0.15f * f), 0.0, 0.0);
                break;
            }
        }
    }

    public static class RenderFactory
    implements IRenderFactory<SiamesePetEntity> {
        public EntityRenderer<SiamesePetEntity> createRenderFor(EntityRendererManager manager) {
            return new SiamesePetRenderer(manager);
        }
    }
}

