/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.networking;

import com.inventorypets.capabilities.DataProvider;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketKeyInput {
    private final int keyInput;

    public PacketKeyInput(int keyInput) {
        this.keyInput = keyInput;
    }

    static void encode(PacketKeyInput msg, PacketBuffer packetBuffer) {
        packetBuffer.writeInt(msg.keyInput);
    }

    static PacketKeyInput decode(PacketBuffer packetBuffer) {
        return new PacketKeyInput(packetBuffer.readInt());
    }

    static void onMessage(PacketKeyInput msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> PacketKeyInput.handleMessage(msg, ((NetworkEvent.Context)contextSupplier.get()).getSender()));
        context.setPacketHandled(true);
    }

    private static void handleMessage(PacketKeyInput msg, ServerPlayerEntity sender) {
        int keyInput = msg.keyInput;
        sender.getCapability(DataProvider.CAPS).ifPresent(props -> props.setKeyInput(keyInput));
    }
}

