/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.handler;

import javax.annotation.Nonnull;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ContainerItemHandler
extends ItemStackHandler {
    private ItemStack itemStack;
    private int size;
    private boolean dirty = false;
    private boolean loaded = false;

    public ContainerItemHandler(ItemStack itemStack, int size) {
        super(size);
        this.size = size;
        this.itemStack = itemStack;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        CompoundNBT tag;
        if (stack.func_77973_b() instanceof BlockItem && ((BlockItem)stack.func_77973_b()).func_179223_d().func_203417_a((ITag)BlockTags.field_226150_J_)) {
            return stack;
        }
        if (stack.func_77942_o() && ((tag = stack.func_77978_p()).func_74764_b("Items") || tag.func_74764_b("Inventory"))) {
            return stack;
        }
        if (stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
            return stack;
        }
        this.dirty = true;
        return super.insertItem(slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        this.dirty = true;
        return super.extractItem(slot, amount, simulate);
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.validateSlotIndex(slot);
        if (!ItemStack.func_77970_a((ItemStack)stack, (ItemStack)((ItemStack)this.stacks.get(slot)))) {
            this.onContentsChanged(slot);
        }
        this.stacks.set(slot, (Object)stack);
    }

    public void setDirty() {
        this.dirty = true;
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.dirty = true;
    }

    public void load() {
        this.load(this.itemStack.func_196082_o());
    }

    public void loadIfNotLoaded() {
        if (!this.loaded) {
            this.load();
        }
        this.loaded = true;
    }

    public void load(@Nonnull CompoundNBT nbt) {
        if (nbt.func_74764_b("Inventory")) {
            this.deserializeNBT(nbt.func_74775_l("Inventory"));
        }
    }

    public void save() {
        if (this.dirty) {
            CompoundNBT nbt = this.itemStack.func_196082_o();
            nbt.func_218657_a("Inventory", (INBT)this.serializeNBT());
            this.dirty = false;
        }
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.setSize(this.size);
        ListNBT tagList = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT itemTags = tagList.func_150305_b(i);
            int slot = itemTags.func_74762_e("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            this.stacks.set(slot, (Object)ItemStack.func_199557_a((CompoundNBT)itemTags));
        }
        this.onLoad();
    }
}

