/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.tileentity;

import com.mrcrayfish.vehicle.block.BlockJack;
import com.mrcrayfish.vehicle.entity.EntityJack;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.init.ModEntities;
import com.mrcrayfish.vehicle.init.ModSounds;
import com.mrcrayfish.vehicle.init.ModTileEntities;
import com.mrcrayfish.vehicle.tileentity.TileEntitySynced;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class JackTileEntity
extends TileEntitySynced
implements ITickableTileEntity {
    public static final int MAX_LIFT_PROGRESS = 20;
    private EntityJack jack = null;
    private boolean activated = false;
    public int prevLiftProgress;
    public int liftProgress;

    public JackTileEntity() {
        super((TileEntityType)ModTileEntities.JACK.get());
    }

    public void setVehicle(VehicleEntity vehicle) {
        this.jack = new EntityJack((EntityType<? extends EntityJack>)((EntityType)ModEntities.JACK.get()), this.field_145850_b, this.field_174879_c, 0.5625, vehicle.field_70177_z);
        vehicle.func_184205_a(this.jack, true);
        this.jack.func_70098_U();
        this.field_145850_b.func_217376_c((Entity)this.jack);
    }

    @Nullable
    public EntityJack getJack() {
        return this.jack;
    }

    public void func_73660_a() {
        List jacks;
        this.prevLiftProgress = this.liftProgress;
        if (this.jack == null && (jacks = this.field_145850_b.func_217357_a(EntityJack.class, new AxisAlignedBB(this.field_174879_c))).size() > 0) {
            this.jack = (EntityJack)((Object)jacks.get(0));
        }
        if (this.jack != null && (this.jack.func_184188_bt().isEmpty() || !this.jack.func_70089_S())) {
            this.jack = null;
        }
        if (this.jack != null) {
            if (this.jack.func_184188_bt().size() > 0) {
                if (!this.activated) {
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, (SoundEvent)ModSounds.JACK_UP.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                    this.activated = true;
                }
            } else if (this.activated) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, (SoundEvent)ModSounds.JACK_DOWN.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.activated = false;
            }
        } else if (this.activated) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, (SoundEvent)ModSounds.JACK_DOWN.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            this.activated = false;
        }
        if (this.activated) {
            if (this.liftProgress < 20) {
                ++this.liftProgress;
                this.moveCollidedEntities();
            }
        } else if (this.liftProgress > 0) {
            --this.liftProgress;
            this.moveCollidedEntities();
        }
    }

    private void moveCollidedEntities() {
        AxisAlignedBB boundingBox;
        List list;
        BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockJack && !(list = this.field_145850_b.func_72839_b((Entity)this.jack, boundingBox = state.func_196954_c((IBlockReader)this.field_145850_b, this.field_174879_c).func_197752_a().func_186670_a(this.field_174879_c))).isEmpty()) {
            for (Entity entity : list) {
                if (entity.func_184192_z() == PushReaction.IGNORE) continue;
                AxisAlignedBB entityBoundingBox = entity.func_174813_aQ();
                double posY = boundingBox.field_72337_e - entityBoundingBox.field_72338_b;
                entity.func_213315_a(MoverType.PISTON, new Vector3d(0.0, posY, 0.0));
            }
        }
    }

    public float getProgress() {
        return (float)this.liftProgress / 20.0f;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

