/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mrcrayfish.vehicle.block.BlockRotatedObject;
import com.mrcrayfish.vehicle.client.render.Axis;
import com.mrcrayfish.vehicle.init.ModBlocks;
import com.mrcrayfish.vehicle.tileentity.GasPumpTankTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.fluid.FluidState;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.ForgeHooksClient;

public class GasPumpTankRenderer
extends TileEntityRenderer<GasPumpTankTileEntity> {
    public GasPumpTankRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(GasPumpTankTileEntity gasPump, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, int overlay) {
        BlockState state = gasPump.func_145831_w().func_180495_p(gasPump.func_174877_v());
        if (state.func_177230_c() != ModBlocks.GAS_PUMP.get()) {
            return;
        }
        matrixStack.func_227860_a_();
        Direction facing = (Direction)state.func_177229_b((Property)BlockRotatedObject.DIRECTION);
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        matrixStack.func_227863_a_(Axis.POSITIVE_Y.func_229187_a_((float)facing.func_176736_b() * -90.0f - 90.0f));
        matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
        float height = 11.0f * ((float)gasPump.getFluidTank().getFluidAmount() / (float)gasPump.getFluidTank().getCapacity());
        if (height > 0.0f) {
            this.drawFluid(gasPump, matrixStack, renderTypeBuffer, 0.188125f, 0.1875f, 0.25f, 0.62375f, height * 0.0625f, 0.49875f, light);
        }
        matrixStack.func_227865_b_();
    }

    private void drawFluid(GasPumpTankTileEntity te, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, float x, float y, float z, float width, float height, float depth, int light) {
        if (te.getFluidTank().isEmpty()) {
            return;
        }
        TextureAtlasSprite sprite = ForgeHooksClient.getFluidSprites((IBlockDisplayReader)te.func_145831_w(), (BlockPos)te.func_174877_v(), (FluidState)te.getFluidTank().getFluid().getFluid().func_207188_f())[0];
        float minU = sprite.func_94209_e();
        float maxU = Math.min(minU + (sprite.func_94212_f() - minU) * depth, sprite.func_94212_f());
        float minV = sprite.func_94206_g();
        float maxV = Math.min(minV + (sprite.func_94210_h() - minV) * height, sprite.func_94210_h());
        IVertexBuilder buffer = renderTypeBuffer.getBuffer(RenderType.func_228645_f_());
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        buffer.func_227888_a_(matrix, x + width, y, z + depth).func_227885_a_(0.85f, 0.85f, 0.85f, 1.0f).func_225583_a_(maxU, minV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x + width, y, z).func_227885_a_(0.85f, 0.85f, 0.85f, 1.0f).func_225583_a_(minU, minV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x + width, y + height, z).func_227885_a_(0.85f, 0.85f, 0.85f, 1.0f).func_225583_a_(minU, maxV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x + width, y + height, z + depth).func_227885_a_(0.85f, 0.85f, 0.85f, 1.0f).func_225583_a_(maxU, maxV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x, y, z).func_227885_a_(0.85f, 0.85f, 0.85f, 1.0f).func_225583_a_(minU, minV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x, y, z + depth).func_227885_a_(0.85f, 0.85f, 0.85f, 1.0f).func_225583_a_(maxU, minV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x, y + height, z + depth).func_227885_a_(0.85f, 0.85f, 0.85f, 1.0f).func_225583_a_(maxU, maxV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x, y + height, z).func_227885_a_(0.85f, 0.85f, 0.85f, 1.0f).func_225583_a_(minU, maxV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        maxV = Math.min(minV + (sprite.func_94210_h() - minV) * width, sprite.func_94210_h());
        buffer.func_227888_a_(matrix, x, y + height, z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(maxU, minV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x, y + height, z + depth).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(minU, minV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x + width, y + height, z + depth).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(minU, maxV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x + width, y + height, z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(maxU, maxV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
    }
}

