/*
 * Decompiled with CFR 0.152.
 */
package com.ocelot.vehicle.jei.plugin;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.vehicle.crafting.FluidExtractorRecipe;
import com.mrcrayfish.vehicle.init.ModBlocks;
import com.mrcrayfish.vehicle.util.FluidUtils;
import com.mrcrayfish.vehicle.util.RenderUtil;
import com.ocelot.vehicle.jei.VehicleModJei;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;

public class FluidExtractorCategory
implements IRecipeCategory<FluidExtractorRecipe> {
    private final IDrawableStatic progressOverlayStatic;
    private final IDrawableStatic progressOverlay;
    private final ITickTimer progress;
    private final IDrawableStatic background;
    private final IDrawable icon;
    private final IDrawableAnimated animatedFlame;
    private final IDrawableStatic outputOverlay;
    private final String localizedName;

    public FluidExtractorCategory(IGuiHelper guiHelper) {
        this.progressOverlayStatic = guiHelper.createDrawable(VehicleModJei.RECIPE_GUI_VEHICLE, 176, 0, 24, 17);
        this.progressOverlay = guiHelper.createDrawable(VehicleModJei.RECIPE_GUI_VEHICLE, 200, 0, 24, 17);
        this.progress = guiHelper.createTickTimer(600, 600, false);
        IDrawableStatic staticFlame = guiHelper.createDrawable(VehicleModJei.RECIPE_GUI_VEHICLE, 160, 0, 14, 14);
        this.background = guiHelper.createDrawable(VehicleModJei.RECIPE_GUI_VEHICLE, 0, 66, 112, 61);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.FLUID_EXTRACTOR.get()));
        this.animatedFlame = guiHelper.createAnimatedDrawable(staticFlame, 300, IDrawableAnimated.StartDirection.TOP, true);
        this.outputOverlay = guiHelper.createDrawable(VehicleModJei.RECIPE_GUI_VEHICLE, 160, 14, 16, 59);
        this.localizedName = I18n.func_135052_a((String)"jev.category.fluid_extracting.title", (Object[])new Object[0]);
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(FluidExtractorRecipe recipe, IIngredients ingredients) {
        ingredients.setInput(VanillaTypes.ITEM, (Object)recipe.getIngredient());
        ingredients.setOutput(VanillaTypes.FLUID, (Object)recipe.getResult().createStack());
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public ResourceLocation getUid() {
        return VehicleModJei.FLUID_EXTRACTOR_UID;
    }

    public Class<? extends FluidExtractorRecipe> getRecipeClass() {
        return FluidExtractorRecipe.class;
    }

    public void draw(FluidExtractorRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        this.animatedFlame.draw(matrixStack, 32, 40);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.pushMatrix();
        RenderSystem.multMatrix((Matrix4f)matrixStack.func_227866_c_().func_227870_a_());
        RenderUtil.drawGradientRectHorizontal((int)61, (int)22, (int)(60 + this.progressOverlay.getWidth()), (int)(21 + this.progressOverlay.getHeight()), (int)-1, (int)(0xFF000000 | FluidUtils.getAverageFluidColor((Fluid)recipe.getResult().getFluid())));
        RenderSystem.popMatrix();
        this.progressOverlayStatic.draw(matrixStack, 61, 22);
        this.progressOverlay.draw(matrixStack, 61, 22, 0, 0, (int)(22.0 * ((double)this.progress.getValue() / (double)this.progress.getMaxValue()) + 1.0), 0);
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
    }

    public void setRecipe(IRecipeLayout recipeLayout, @Nonnull FluidExtractorRecipe recipe, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluids = recipeLayout.getFluidStacks();
        stacks.init(0, true, 31, 19);
        fluids.init(0, false, 95, 1, 16, 59, 5000, false, (IDrawable)this.outputOverlay);
        stacks.set(ingredients);
        fluids.set(ingredients);
    }
}

