/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.client.IModelOffsetProvider;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.ImmersiveConnectableTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.AbstractTransformerTileEntity;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class TransformerTileEntity
extends AbstractTransformerTileEntity
implements IEBlockInterfaces.IMirrorAble,
IEBlockInterfaces.IHasDummyBlocks,
IModelOffsetProvider,
IEBlockInterfaces.IBlockBounds {
    public int dummy = 0;
    private static final CachedShapesWithTransform<ShapeKey, Pair<Direction, Boolean>> SHAPES = new CachedShapesWithTransform<ShapeKey, Pair>(key -> ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.3125, 0.375, ((ShapeKey)key).lowerHeight, 0.6875), (Object)new AxisAlignedBB(0.625, 0.0, 0.3125, 1.0, ((ShapeKey)key).higherHeight, 0.6875)), (pair, aabb) -> CachedShapesWithTransform.withFacingAndMirror(aabb, (Direction)pair.getFirst(), (Boolean)pair.getSecond()));

    public TransformerTileEntity() {
        super((TileEntityType<? extends ImmersiveConnectableTileEntity>)((TileEntityType)IETileTypes.TRANSFORMER.get()));
    }

    public TransformerTileEntity(TileEntityType<? extends TransformerTileEntity> type) {
        super((TileEntityType<? extends ImmersiveConnectableTileEntity>)type);
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("dummy", this.dummy);
    }

    @Override
    public void readCustomNBT(@Nonnull CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.dummy = nbt.func_74762_e("dummy");
    }

    @Override
    public BlockPos getConnectionMaster(WireType cableType, TargetingInfo target) {
        return this.func_174877_v().func_177982_a(0, -this.dummy, 0);
    }

    @Override
    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vector3i offset) {
        if (this.dummy == 2) {
            TileEntity master = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, -this.dummy, 0));
            return master instanceof TransformerTileEntity && ((TransformerTileEntity)master).canConnectCable(cableType, target, new Vector3i(0, 2, 0));
        }
        return super.canConnectCable(cableType, target, offset);
    }

    @Override
    public void connectCable(WireType cableType, ConnectionPoint target, IImmersiveConnectable other, ConnectionPoint otherTarget) {
        if (this.dummy != 0) {
            TileEntity master = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, -this.dummy, 0));
            if (master instanceof TransformerTileEntity) {
                ((TransformerTileEntity)master).connectCable(cableType, target, other, otherTarget);
            }
        } else {
            super.connectCable(cableType, target, other, otherTarget);
        }
    }

    @Override
    protected Vector3d getConnectionOffset(Connection con, boolean right) {
        double offset;
        double conRadius = con.type.getRenderDiameter() / 2.0;
        double d = offset = this.getHigherWiretype().equals(con.type.getCategory()) ? (double)this.getHigherOffset() : (double)this.getLowerOffset();
        if (this.getFacing() == Direction.NORTH) {
            return new Vector3d(right ? 0.8125 : 0.1875, 2.0 + offset - conRadius, 0.5);
        }
        if (this.getFacing() == Direction.SOUTH) {
            return new Vector3d(right ? 0.1875 : 0.8125, 2.0 + offset - conRadius, 0.5);
        }
        if (this.getFacing() == Direction.WEST) {
            return new Vector3d(0.5, 2.0 + offset - conRadius, right ? 0.1875 : 0.8125);
        }
        if (this.getFacing() == Direction.EAST) {
            return new Vector3d(0.5, 2.0 + offset - conRadius, right ? 0.8125 : 0.1875);
        }
        return new Vector3d(0.5, 0.5, 0.5);
    }

    @Override
    @Nullable
    public ConnectionPoint getTargetedPoint(TargetingInfo target, Vector3i offset) {
        if (offset.func_177956_o() != 2) {
            return null;
        }
        ConnectionPoint leftCP = new ConnectionPoint(this.field_174879_c, 1);
        ConnectionPoint rightCP = new ConnectionPoint(this.field_174879_c, 0);
        boolean leftEmpty = this.getLocalNet(1).getConnections(leftCP).stream().allMatch(Connection::isInternal);
        boolean rightEmpty = this.getLocalNet(0).getConnections(rightCP).stream().allMatch(Connection::isInternal);
        if (leftEmpty && !rightEmpty) {
            return leftCP;
        }
        if (!leftEmpty && rightEmpty) {
            return rightCP;
        }
        Direction facing = this.getFacing();
        double hitPos = facing.func_176740_k() == Direction.Axis.X ? (double)target.hitZ : (double)(1.0f - target.hitX);
        if (hitPos < 0.5 == (facing.func_176743_c() == Direction.AxisDirection.POSITIVE)) {
            return leftCP;
        }
        return rightCP;
    }

    @Override
    protected void updateMirrorState() {
        if (this.dummy != 0) {
            TileEntity master = this.field_145850_b.func_175625_s(this.field_174879_c.func_177979_c(this.dummy));
            if (master instanceof TransformerTileEntity) {
                ((TransformerTileEntity)master).updateMirrorState();
            }
        } else if (this.rightType != null || this.leftType != null) {
            String higher = this.getHigherWiretype();
            boolean intendedState = this.rightType != null && higher.equals(this.rightType.getCategory()) || this.leftType != null && !higher.equals(this.leftType.getCategory());
            for (int i = 0; i < 3; ++i) {
                TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177981_b(i));
                if (!(te instanceof TransformerTileEntity)) continue;
                ((TransformerTileEntity)te).setMirrored(intendedState);
            }
        }
    }

    @Override
    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean isDummy() {
        return this.dummy != 0;
    }

    @Override
    @Nullable
    public IEBlockInterfaces.IGeneralMultiblock master() {
        if (!this.isDummy()) {
            return this;
        }
        BlockPos masterPos = this.func_174877_v().func_177979_c(this.dummy);
        TileEntity te = Utils.getExistingTileEntity(this.field_145850_b, masterPos);
        return this.getClass().isInstance(te) ? (IEBlockInterfaces.IGeneralMultiblock)te : null;
    }

    @Override
    public void placeDummies(BlockItemUseContext ctx, BlockState state) {
        state = (BlockState)state.func_206870_a((Property)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(true));
        int i = 1;
        while (i <= 2) {
            BlockPos dummyPos = this.field_174879_c.func_177981_b(i);
            this.field_145850_b.func_175656_a(dummyPos, IEBaseBlock.applyLocationalWaterlogging(state, this.field_145850_b, dummyPos));
            ((TransformerTileEntity)this.field_145850_b.func_175625_s((BlockPos)dummyPos)).dummy = i++;
            ((TransformerTileEntity)this.field_145850_b.func_175625_s(dummyPos)).setFacing(this.getFacing());
        }
    }

    @Override
    public void breakDummies(BlockPos pos, BlockState state) {
        for (int i = 0; i <= 2; ++i) {
            this.field_145850_b.func_217377_a(this.func_174877_v().func_177982_a(0, -this.dummy, 0).func_177982_a(0, i, 0), false);
        }
    }

    @Override
    @Nonnull
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        if (this.dummy == 2) {
            return SHAPES.get(new ShapeKey(this.getLowerOffset(), this.getHigherOffset()), (Pair<Direction, Boolean>)Pair.of((Object)this.getFacing(), (Object)(!this.getIsMirrored() ? 1 : 0)));
        }
        return VoxelShapes.func_197868_b();
    }

    @Override
    public Set<BlockPos> getIgnored(IImmersiveConnectable other) {
        return ImmutableSet.of((Object)this.field_174879_c.func_177981_b(2));
    }

    protected float getLowerOffset() {
        return 0.5f;
    }

    protected float getHigherOffset() {
        return 0.5625f;
    }

    @Override
    public Collection<ConnectionPoint> getConnectionPoints() {
        if (this.isDummy()) {
            return ImmutableList.of();
        }
        return super.getConnectionPoints();
    }

    @Override
    public Iterable<? extends Connection> getInternalConnections() {
        if (this.isDummy()) {
            return ImmutableList.of();
        }
        return super.getInternalConnections();
    }

    @Override
    public BlockPos getModelOffset(BlockState state, @Nullable Vector3i size) {
        return new BlockPos(0, this.dummy, 0);
    }

    private static class ShapeKey {
        private final double lowerHeight;
        private final double higherHeight;

        private ShapeKey(double lowerHeight, double higherHeight) {
            this.lowerHeight = lowerHeight;
            this.higherHeight = higherHeight;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShapeKey shapeKey = (ShapeKey)o;
            return Double.compare(shapeKey.lowerHeight, this.lowerHeight) == 0 && Double.compare(shapeKey.higherHeight, this.higherHeight) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.lowerHeight, this.higherHeight);
        }
    }
}

