/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import snownee.kiwi.util.LootDumper;

public class KiwiCommand {
    private static final SimpleCommandExceptionType WRONG_PATTERN_EXCEPTION = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.kiwi.dumpLoots.wrongPattern"));

    public static void register(CommandDispatcher<CommandSource> dispatcher, Commands.EnvironmentType environmentType) {
        LiteralArgumentBuilder builder = Commands.func_197057_a((String)"kiwi");
        if (environmentType != Commands.EnvironmentType.DEDICATED) {
            builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"dumpLoots").executes(ctx -> KiwiCommand.dumpLoots((CommandSource)ctx.getSource(), ".+"))).then(Commands.func_197056_a((String)"pattern", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> KiwiCommand.dumpLoots((CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"pattern")))));
        }
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"debugWorldRules").requires(ctx -> ctx.func_197034_c(2))).executes(ctx -> KiwiCommand.cleanWorld((CommandSource)ctx.getSource())));
        dispatcher.register(builder);
    }

    public static int dumpLoots(CommandSource source, String pattern) throws CommandSyntaxException {
        try {
            Pattern p = Pattern.compile(pattern);
            int r = LootDumper.dump(p, source.func_197028_i().func_71238_n());
            if (r == 0) {
                source.func_197021_a((ITextComponent)new TranslationTextComponent("commands.kiwi.dumpLoots.noTargets"));
            } else {
                source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.kiwi.dumpLoots.success", new Object[]{r}), true);
            }
            return r;
        }
        catch (PatternSyntaxException e) {
            throw WRONG_PATTERN_EXCEPTION.create();
        }
    }

    private static int cleanWorld(CommandSource source) {
        Commands commands = source.func_197028_i().func_195571_aL();
        commands.func_197059_a(source, "gamerule doDaylightCycle false");
        commands.func_197059_a(source, "gamerule doWeatherCycle false");
        commands.func_197059_a(source, "gamerule doMobLoot false");
        commands.func_197059_a(source, "gamerule doMobSpawning false");
        commands.func_197059_a(source, "difficulty peaceful");
        commands.func_197059_a(source, "kill @e[type=!minecraft:player]");
        commands.func_197059_a(source, "time set day");
        commands.func_197059_a(source, "weather clear");
        commands.func_197059_a(source, "gamerule doMobLoot true");
        return 1;
    }
}

