/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WoodButtonBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import snownee.kiwi.tile.BaseTile;
import snownee.kiwi.util.DeferredActions;

public class ModBlock
extends Block {
    public ModBlock(AbstractBlock.Properties builder) {
        super(builder);
    }

    public static SoundType deduceSoundType(Material material) {
        if (material == Material.field_151575_d || material == Material.field_151572_C) {
            return SoundType.field_185848_a;
        }
        if (material == Material.field_151578_c || material == Material.field_151571_B) {
            return SoundType.field_185849_b;
        }
        if (material == Material.field_151585_k || material == Material.field_151577_b || material == Material.field_151582_l || material == Material.field_151584_j || material == Material.field_151583_m || material == Material.field_151590_u) {
            return SoundType.field_185850_c;
        }
        if (material == Material.field_204868_h || material == Material.field_203243_f) {
            return SoundType.field_211382_m;
        }
        if (material == Material.field_151573_f) {
            return SoundType.field_185852_e;
        }
        if (material == Material.field_151592_s || material == Material.field_151567_E || material == Material.field_151588_w || material == Material.field_151598_x || material == Material.field_151591_t) {
            return SoundType.field_185853_f;
        }
        if (material == Material.field_151580_n || material == Material.field_151593_r || material == Material.field_151570_A || material == Material.field_151568_F || material == Material.field_151581_o) {
            return SoundType.field_185854_g;
        }
        if (material == Material.field_151595_p) {
            return SoundType.field_185855_h;
        }
        if (material == Material.field_151597_y || material == Material.field_151596_z) {
            return SoundType.field_185856_i;
        }
        if (material == Material.field_151574_g) {
            return SoundType.field_185858_k;
        }
        return SoundType.field_185851_d;
    }

    public static float deduceHardness(Material material) {
        if (material == Material.field_151585_k || material == Material.field_151579_a || material == Material.field_151581_o) {
            return 0.0f;
        }
        if (material == Material.field_151576_e) {
            return 2.5f;
        }
        if (material == Material.field_151575_d) {
            return 2.0f;
        }
        if (material == Material.field_151577_b) {
            return 0.6f;
        }
        if (material == Material.field_151595_p || material == Material.field_151578_c || material == Material.field_151571_B) {
            return 0.5f;
        }
        if (material == Material.field_151592_s) {
            return 0.3f;
        }
        if (material == Material.field_151570_A) {
            return 0.4f;
        }
        if (material == Material.field_151573_f || material == Material.field_151574_g) {
            return 5.0f;
        }
        if (material == Material.field_151569_G) {
            return 4.0f;
        }
        if (material == Material.field_151580_n) {
            return 0.8f;
        }
        if (material == Material.field_151586_h || material == Material.field_151587_i) {
            return 100.0f;
        }
        return 1.0f;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return ModBlock.pickBlock(state, target, world, pos, player);
    }

    public static ItemStack pickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        ItemStack stack = state.func_177230_c().func_185473_a(world, pos, state);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof BaseTile && !tile.func_183000_F() && ((BaseTile)tile).persistData) {
            CompoundNBT data = tile.func_189515_b(new CompoundNBT());
            data.func_82580_o("x");
            data.func_82580_o("y");
            data.func_82580_o("z");
            data.func_82580_o("id");
            stack.func_77983_a("BlockEntityTag", (INBT)data);
        }
        return stack;
    }

    public static void setFireInfo(Block block) {
        Material material = block.field_149764_J;
        int fireSpreadSpeed = 0;
        int flammability = 0;
        if (material == Material.field_151575_d) {
            if (!(block instanceof DoorBlock || block instanceof TrapDoorBlock || block instanceof WoodButtonBlock || block instanceof PressurePlateBlock)) {
                fireSpreadSpeed = 5;
                flammability = 20;
            }
        } else if (material == Material.field_151585_k || material == Material.field_151582_l) {
            if (!(block instanceof SaplingBlock)) {
                fireSpreadSpeed = 30;
                flammability = 100;
            }
        } else if (material == Material.field_151593_r) {
            fireSpreadSpeed = 60;
            flammability = 20;
        } else if (material == Material.field_151584_j) {
            fireSpreadSpeed = 30;
            flammability = 60;
        } else if (material == Material.field_151580_n) {
            fireSpreadSpeed = 30;
            flammability = 60;
        }
        if (fireSpreadSpeed != 0) {
            DeferredActions.setFireInfo(block, fireSpreadSpeed, flammability);
        }
    }
}

