/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen.deserialisation;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;

public class JsonMath {
    public MathOperator rootOp;
    public static final MathOperator NULL_OPERATOR = new Null();

    public JsonMath(JsonElement mathElement) {
        if (mathElement.isJsonObject()) {
            JsonObject mathObject = mathElement.getAsJsonObject();
            for (Map.Entry entry : mathObject.entrySet()) {
                this.rootOp = this.processElement((String)entry.getKey(), (JsonElement)entry.getValue());
                if (this.rootOp == NULL_OPERATOR) continue;
                return;
            }
        }
    }

    private MathOperator getVariable(String name) {
        if (MathFunction.NOISE.name.equals(name)) {
            return new Noise();
        }
        if (MathFunction.RAND.name.equals(name)) {
            return new Rand();
        }
        if (MathFunction.RADIUS.name.equals(name)) {
            return new Radius();
        }
        return NULL_OPERATOR;
    }

    private MathOperator processElement(String key, JsonElement value) {
        MathFunction op = MathFunction.getFunction(key);
        if (op == null) {
            return NULL_OPERATOR;
        }
        ArrayList<MathOperator> paramList = new ArrayList<MathOperator>();
        Species speciesArg = Species.NULL_SPECIES;
        if (value.isJsonArray()) {
            for (JsonElement parameter : value.getAsJsonArray()) {
                MathOperator m = NULL_OPERATOR;
                if (parameter.isJsonObject()) {
                    Map.Entry entry = (Map.Entry)parameter.getAsJsonObject().entrySet().iterator().next();
                    m = this.processElement((String)entry.getKey(), (JsonElement)entry.getValue());
                } else if (parameter.isJsonPrimitive()) {
                    if (parameter.getAsJsonPrimitive().isNumber()) {
                        m = new Const(parameter.getAsFloat());
                    } else if (parameter.getAsJsonPrimitive().isString()) {
                        String name = parameter.getAsString();
                        MathOperator var = this.getVariable(name);
                        if (var != NULL_OPERATOR) {
                            m = var;
                        } else if (TreeRegistry.findSpeciesSloppy(name) != Species.NULL_SPECIES) {
                            speciesArg = TreeRegistry.findSpeciesSloppy(name);
                        }
                    }
                }
                if (m == NULL_OPERATOR) continue;
                paramList.add(m);
            }
        }
        MathOperator[] paramArray = paramList.toArray(new MathOperator[0]);
        switch (op) {
            case NOISE: {
                return new Noise();
            }
            case RAND: {
                return new Rand();
            }
            case RADIUS: {
                return new Radius();
            }
            case ADD: {
                return new Adder(paramArray);
            }
            case SUB: {
                return new Subtractor(paramArray);
            }
            case MUL: {
                return new Multiplier(paramArray);
            }
            case DIV: {
                return new Divider(paramArray);
            }
            case MAX: {
                return new Maximum(paramArray);
            }
            case MIN: {
                return new Minimum(paramArray);
            }
            case IFGT: {
                return new IfGreaterThan(paramArray);
            }
            case SPECIES: {
                return speciesArg != Species.NULL_SPECIES ? new IfSpecies(speciesArg, paramArray) : null;
            }
            case DEBUG: {
                return new Debug(paramArray);
            }
        }
        return NULL_OPERATOR;
    }

    public float apply(Random random, float noise) {
        MathContext mc = new MathContext(noise, random);
        return this.rootOp.apply(mc);
    }

    public float apply(Random random, Species species, float radius) {
        MathSpeciesContext mc = new MathSpeciesContext(random, species, radius);
        return this.rootOp.apply(mc);
    }

    public static enum MathFunction {
        CONST,
        NOISE,
        RAND,
        RADIUS,
        ADD,
        SUB,
        MUL,
        DIV,
        MOD,
        MAX,
        MIN,
        IFGT,
        SPECIES,
        DEBUG;

        public final String name = this.toString().toLowerCase();

        @Nullable
        static MathFunction getFunction(String findName) {
            for (MathFunction fun : MathFunction.values()) {
                if (!fun.name.equals(findName)) continue;
                return fun;
            }
            return null;
        }
    }

    private static class Null
    implements MathOperator {
        private Null() {
        }

        @Override
        public float apply(MathContext mc) {
            return 0.0f;
        }
    }

    public static class Debug
    implements MathOperator {
        private final MathOperator[] functions;

        public Debug(MathOperator[] functionArray) {
            this.functions = functionArray;
        }

        @Override
        public float apply(MathContext mc) {
            if (this.functions.length >= 1) {
                float val = this.functions[0].apply(mc);
                LogManager.getLogger().debug("Json Debug Value: " + val);
                return val;
            }
            return 0.0f;
        }
    }

    public static class IfSpecies
    implements MathOperator {
        private final MathOperator[] functions;
        private final Species species;

        public IfSpecies(Species species, MathOperator[] functionArray) {
            this.species = species;
            this.functions = functionArray;
        }

        @Override
        public float apply(MathContext mc) {
            if (mc instanceof MathSpeciesContext && this.functions.length == 2) {
                return ((MathSpeciesContext)mc).species == this.species ? this.functions[0].apply(mc) : this.functions[1].apply(mc);
            }
            return 0.0f;
        }
    }

    public static class IfGreaterThan
    implements MathOperator {
        private final MathOperator[] functions;

        public IfGreaterThan(MathOperator[] functionArray) {
            this.functions = functionArray;
        }

        @Override
        public float apply(MathContext mc) {
            if (this.functions.length == 4) {
                return this.functions[0].apply(mc) > this.functions[1].apply(mc) ? this.functions[2].apply(mc) : this.functions[3].apply(mc);
            }
            return 0.0f;
        }
    }

    public static class Minimum
    implements MathOperator {
        private final MathOperator[] functions;
        private final boolean dual;

        public Minimum(MathOperator[] functionArray) {
            this.functions = functionArray;
            this.dual = this.functions.length == 2;
        }

        @Override
        public float apply(MathContext mc) {
            if (this.dual) {
                return Math.min(this.functions[0].apply(mc), this.functions[1].apply(mc));
            }
            Float r = null;
            for (MathOperator f : this.functions) {
                float v = f.apply(mc);
                r = Float.valueOf(r == null ? v : Math.min(r.floatValue(), v));
            }
            return r == null ? 0.0f : r.floatValue();
        }
    }

    public static class Maximum
    implements MathOperator {
        private final MathOperator[] functions;
        private final boolean dual;

        public Maximum(MathOperator[] functionArray) {
            this.functions = functionArray;
            this.dual = this.functions.length == 2;
        }

        @Override
        public float apply(MathContext mc) {
            if (this.dual) {
                return Math.max(this.functions[0].apply(mc), this.functions[1].apply(mc));
            }
            Float r = null;
            for (MathOperator f : this.functions) {
                float v = f.apply(mc);
                r = Float.valueOf(r == null ? v : Math.max(r.floatValue(), v));
            }
            return r == null ? 0.0f : r.floatValue();
        }
    }

    public static class Modulus
    implements MathOperator {
        private final MathOperator[] functions;
        private final boolean dual;

        public Modulus(MathOperator[] functionArray) {
            this.functions = functionArray;
            this.dual = this.functions.length == 2;
        }

        @Override
        public float apply(MathContext mc) {
            if (this.dual) {
                return this.functions[0].apply(mc) % this.functions[1].apply(mc);
            }
            return 0.0f;
        }
    }

    public static class Divider
    implements MathOperator {
        private final MathOperator[] functions;
        private final boolean dual;

        public Divider(MathOperator[] functionArray) {
            this.functions = functionArray;
            this.dual = this.functions.length == 2;
        }

        @Override
        public float apply(MathContext mc) {
            if (this.dual) {
                return this.functions[0].apply(mc) / this.functions[1].apply(mc);
            }
            Float r = null;
            for (MathOperator f : this.functions) {
                float v = f.apply(mc);
                r = Float.valueOf(r == null ? v : r.floatValue() / v);
            }
            return r == null ? 0.0f : r.floatValue();
        }
    }

    public static class Multiplier
    implements MathOperator {
        private final MathOperator[] functions;
        private final boolean dual;

        public Multiplier(MathOperator[] functionArray) {
            this.functions = functionArray;
            this.dual = this.functions.length == 2;
        }

        @Override
        public float apply(MathContext mc) {
            if (this.dual) {
                return this.functions[0].apply(mc) * this.functions[1].apply(mc);
            }
            float r = 1.0f;
            for (MathOperator f : this.functions) {
                r *= f.apply(mc);
            }
            return r;
        }
    }

    public static class Subtractor
    implements MathOperator {
        private final MathOperator[] functions;
        private final boolean dual;

        public Subtractor(MathOperator[] functionArray) {
            this.functions = functionArray;
            this.dual = this.functions.length == 2;
        }

        @Override
        public float apply(MathContext mc) {
            if (this.dual) {
                return this.functions[0].apply(mc) - this.functions[1].apply(mc);
            }
            Float r = null;
            for (MathOperator f : this.functions) {
                float v = f.apply(mc);
                r = Float.valueOf(r == null ? v : r.floatValue() - v);
            }
            return r == null ? 0.0f : r.floatValue();
        }
    }

    public static class Adder
    implements MathOperator {
        private final MathOperator[] functions;
        private final boolean dual;

        public Adder(MathOperator[] functionArray) {
            this.functions = functionArray;
            this.dual = this.functions.length == 2;
        }

        @Override
        public float apply(MathContext mc) {
            if (this.dual) {
                return this.functions[0].apply(mc) + this.functions[1].apply(mc);
            }
            float r = 0.0f;
            for (MathOperator f : this.functions) {
                r += f.apply(mc);
            }
            return r;
        }
    }

    public static class Radius
    implements MathOperator {
        @Override
        public float apply(MathContext mc) {
            if (mc instanceof MathSpeciesContext) {
                return ((MathSpeciesContext)mc).radius;
            }
            return 0.0f;
        }
    }

    public static class Rand
    implements MathOperator {
        @Override
        public float apply(MathContext mc) {
            return mc.rand.nextFloat();
        }
    }

    public static class Noise
    implements MathOperator {
        @Override
        public float apply(MathContext mc) {
            return mc.noise;
        }
    }

    public static class Const
    implements MathOperator {
        private final float value;

        Const(float value) {
            this.value = value;
        }

        @Override
        public float apply(MathContext mc) {
            return this.value;
        }
    }

    public static interface MathOperator {
        public float apply(MathContext var1);
    }

    public static class MathSpeciesContext
    extends MathContext {
        public float radius;
        public Species species;

        public MathSpeciesContext(Random random, Species species, float radius) {
            super(0.0f, random);
            this.radius = radius;
            this.species = species;
        }
    }

    public static class MathContext {
        public float noise;
        public Random rand;

        public MathContext(float noise, Random random) {
            this.noise = noise;
            this.rand = random;
        }
    }
}

