/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen.cancellers;

import com.ferreusveritas.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.ferreusveritas.dynamictrees.api.worldgen.FeatureCanceller;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.ConfiguredRandomFeatureList;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;

public class TreeFeatureCanceller<T extends IFeatureConfig>
extends FeatureCanceller {
    private final Class<T> treeFeatureConfigClass;

    public TreeFeatureCanceller(ResourceLocation registryName, Class<T> treeFeatureConfigClass) {
        super(registryName);
        this.treeFeatureConfigClass = treeFeatureConfigClass;
    }

    @Override
    public boolean shouldCancel(ConfiguredFeature<?, ?> configuredFeature, BiomePropertySelectors.FeatureCancellations featureCancellations) {
        if (!(configuredFeature.field_222738_b instanceof DecoratedFeatureConfig)) {
            return false;
        }
        IFeatureConfig featureConfig = ((ConfiguredFeature)((DecoratedFeatureConfig)configuredFeature.field_222738_b).field_214689_a.get()).field_222738_b;
        if (featureConfig instanceof MultipleRandomFeatureConfig) {
            return this.doesContainTrees((MultipleRandomFeatureConfig)featureConfig, featureCancellations);
        }
        if (featureConfig instanceof DecoratedFeatureConfig) {
            ConfiguredFeature nextConfiguredFeature = (ConfiguredFeature)((DecoratedFeatureConfig)featureConfig).field_214689_a.get();
            IFeatureConfig nextFeatureConfig = nextConfiguredFeature.field_222738_b;
            ResourceLocation featureRegistryName = nextConfiguredFeature.field_222737_a.getRegistryName();
            if (this.treeFeatureConfigClass.isInstance(nextFeatureConfig) && featureRegistryName != null && featureCancellations.shouldCancelNamespace(featureRegistryName.func_110624_b())) {
                return true;
            }
            if (nextFeatureConfig instanceof MultipleRandomFeatureConfig) {
                return this.doesContainTrees((MultipleRandomFeatureConfig)nextFeatureConfig, featureCancellations);
            }
        }
        return false;
    }

    private boolean doesContainTrees(MultipleRandomFeatureConfig featureConfig, BiomePropertySelectors.FeatureCancellations featureCancellations) {
        for (ConfiguredRandomFeatureList feature : featureConfig.field_202449_a) {
            ConfiguredFeature currentConfiguredFeature = (ConfiguredFeature)feature.field_214842_a.get();
            ResourceLocation featureRegistryName = currentConfiguredFeature.field_222737_a.getRegistryName();
            if (!this.treeFeatureConfigClass.isInstance(currentConfiguredFeature.field_222738_b) || featureRegistryName == null || !featureCancellations.shouldCancelNamespace(featureRegistryName.func_110624_b())) continue;
            return true;
        }
        return false;
    }
}

