/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen;

import com.ferreusveritas.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.ferreusveritas.dynamictrees.api.worldgen.FeatureCanceller;
import com.ferreusveritas.dynamictrees.init.DTRegistries;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDatabases;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class WorldGenEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void addDynamicTrees(BiomeLoadingEvent event) {
        event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, DTRegistries.DYNAMIC_TREE_CONFIGURED_FEATURE);
    }

    @SubscribeEvent
    public void removeVanillaTrees(BiomeLoadingEvent event) {
        ResourceLocation biomeName = event.getName();
        if (biomeName == null) {
            return;
        }
        BiomePropertySelectors.FeatureCancellations featureCancellations = BiomeDatabases.getDefault().getEntry(biomeName).getFeatureCancellations();
        featureCancellations.getStages().forEach(stage -> event.getGeneration().getFeatures(stage).removeIf(configuredFeatureSupplier -> {
            for (FeatureCanceller featureCanceller : featureCancellations.getFeatureCancellers()) {
                if (!featureCanceller.shouldCancel((ConfiguredFeature)configuredFeatureSupplier.get(), featureCancellations)) continue;
                return true;
            }
            return false;
        }));
    }
}

